"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AlertDropdown = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/logs-shared-plugin/public");
var _alert_flyout = require("./alert_flyout");
var _use_kibana = require("../../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const readOnlyUserTooltipContent = _i18n.i18n.translate('xpack.infra.logs.alertDropdown.readOnlyCreateAlertContent', {
  defaultMessage: 'Creating alerts requires more permissions in this application.'
});
const readOnlyUserTooltipTitle = _i18n.i18n.translate('xpack.infra.logs.alertDropdown.readOnlyCreateAlertTitle', {
  defaultMessage: 'Read only'
});
const inlineLogViewTooltipTitle = _i18n.i18n.translate('xpack.infra.logs.alertDropdown.inlineLogViewCreateAlertTitle', {
  defaultMessage: 'Inline Log View'
});
const inlineLogViewTooltipContent = _i18n.i18n.translate('xpack.infra.logs.alertDropdown.inlineLogViewCreateAlertContent', {
  defaultMessage: 'Creating alerts is not supported with inline Log Views'
});
const AlertDropdown = () => {
  var _capabilities$logs, _ref;
  const {
    services: {
      application: {
        capabilities
      },
      observability
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    isPersistedLogView
  } = (0, _public.useLogViewContext)();
  const readOnly = !(capabilities !== null && capabilities !== void 0 && (_capabilities$logs = capabilities.logs) !== null && _capabilities$logs !== void 0 && _capabilities$logs.save);
  const canCreateAlerts = (_ref = !readOnly && isPersistedLogView) !== null && _ref !== void 0 ? _ref : false;
  const [popoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [flyoutVisible, setFlyoutVisible] = (0, _react.useState)(false);
  const manageRulesLinkProps = observability.useRulesLink({
    hrefOnly: true
  });
  const closePopover = (0, _react.useCallback)(() => {
    setPopoverOpen(false);
  }, [setPopoverOpen]);
  const openPopover = (0, _react.useCallback)(() => {
    setPopoverOpen(true);
  }, [setPopoverOpen]);
  const openFlyout = (0, _react.useCallback)(() => {
    setFlyoutVisible(true);
    closePopover();
  }, [setFlyoutVisible, closePopover]);
  const menuItems = (0, _react.useMemo)(() => {
    return [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      disabled: !canCreateAlerts,
      icon: "bell",
      key: "createLink",
      onClick: openFlyout,
      toolTipContent: !canCreateAlerts ? readOnly ? readOnlyUserTooltipContent : inlineLogViewTooltipContent : undefined,
      toolTipProps: {
        title: !canCreateAlerts ? readOnly ? readOnlyUserTooltipTitle : inlineLogViewTooltipTitle : undefined
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.alerting.logs.createAlertButton",
      defaultMessage: "Create rule"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
      icon: "tableOfContents",
      key: "manageLink"
    }, manageRulesLinkProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.alerting.logs.manageAlerts",
      defaultMessage: "Manage rules"
    }))];
  }, [canCreateAlerts, openFlyout, readOnly, manageRulesLinkProps]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
      color: "primary",
      iconSide: 'right',
      iconType: 'arrowDown',
      onClick: openPopover
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.alerting.logs.alertsButton",
      defaultMessage: "Alerts"
    })),
    isOpen: popoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: menuItems
  })), /*#__PURE__*/_react.default.createElement(_alert_flyout.AlertFlyout, {
    setVisible: setFlyoutVisible,
    visible: flyoutVisible
  }));
};

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
exports.AlertDropdown = AlertDropdown;
var _default = exports.default = AlertDropdown;