"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorToInference = void 0;
var _errors = require("../errors");
var _is_supported_connector = require("./is_supported_connector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Converts an action connector to the internal inference connector format.
 *
 * The function will throw if the provided connector is not compatible
 */
const connectorToInference = connector => {
  var _connector$config;
  if (!(0, _is_supported_connector.isSupportedConnector)(connector)) {
    throw (0, _errors.createInferenceRequestError)(`Connector '${connector.id}' of type '${connector.actionTypeId}' not recognized as a supported connector`, 400);
  }
  return {
    connectorId: connector.id,
    name: connector.name,
    type: connector.actionTypeId,
    config: (_connector$config = connector.config) !== null && _connector$config !== void 0 ? _connector$config : {}
  };
};
exports.connectorToInference = connectorToInference;