"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "extensionsService", {
  enumerable: true,
  get: function () {
    return _extension_service.extensionsService;
  }
});
exports.isSortAscending = exports.indicesLoading = exports.indicesError = exports.getTotalItems = exports.getTableState = exports.getTableLocationProp = exports.getSortField = exports.getRowStatuses = exports.getPager = exports.getPageOfIndices = exports.getIndicesByName = exports.getIndicesAsArray = exports.getIndices = exports.getIndexStatusByIndexName = exports.getIndexByIndexName = exports.getFilteredIndices = exports.getFilteredIds = exports.getFilter = exports.getAllIds = void 0;
var _eui = require("@elastic/eui");
var _reselect = require("reselect");
var _index_status_labels = require("../../lib/index_status_labels");
var _services = require("../../services");
var _extension_service = require("./extension_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndices = state => state.indices.byId;
exports.getIndices = getIndices;
const indicesLoading = state => state.indices.loading;
exports.indicesLoading = indicesLoading;
const indicesError = state => state.indices.error;
exports.indicesError = indicesError;
const getIndicesAsArray = state => Object.values(state.indices.byId);
exports.getIndicesAsArray = getIndicesAsArray;
const getIndicesByName = (state, indexNames) => {
  const indices = getIndices(state);
  return indexNames.map(indexName => indices[indexName]);
};
exports.getIndicesByName = getIndicesByName;
const getIndexByIndexName = (state, name) => getIndices(state)[name];
exports.getIndexByIndexName = getIndexByIndexName;
const getFilteredIds = state => state.indices.filteredIds;
exports.getFilteredIds = getFilteredIds;
const getRowStatuses = state => state.rowStatus;
exports.getRowStatuses = getRowStatuses;
const getTableState = state => state.tableState;
exports.getTableState = getTableState;
const getTableLocationProp = (_, props) => props.location;
exports.getTableLocationProp = getTableLocationProp;
const getAllIds = state => state.indices.allIds;
exports.getAllIds = getAllIds;
const getIndexStatusByIndexName = (state, indexName) => {
  const indices = getIndices(state);
  const {
    status
  } = indices[indexName] || {};
  return status;
};
exports.getIndexStatusByIndexName = getIndexStatusByIndexName;
const defaultFilterFields = ['name'];
const filterByToggles = (indices, toggleNameToVisibleMap) => {
  const togglesByName = _extension_service.extensionsService.toggles.reduce((byName, toggle) => ({
    ...byName,
    [toggle.name]: toggle
  }), {});
  const toggleNames = Object.keys(togglesByName);
  if (!toggleNames.length) {
    return indices;
  }
  return indices.filter(index => {
    return toggleNames.every(toggleName => {
      // if an index matches a toggle, it's only shown if the toggle is set to "enabled"
      // for example, a hidden index is only shown when the "include hidden" toggle is "enabled"
      if (togglesByName[toggleName].matchIndex(index)) {
        return toggleNameToVisibleMap[toggleName] === true;
      }
      // otherwise the index is shown by default
      return true;
    });
  });
};
const getFilteredIndices = exports.getFilteredIndices = (0, _reselect.createSelector)(getIndices, getAllIds, getTableState, (indices, allIds, tableState) => {
  let indexArray = allIds.map(indexName => indices[indexName]);
  indexArray = filterByToggles(indexArray, tableState.toggleNameToVisibleMap);
  const filter = tableState.filter || _eui.EuiSearchBar.Query.MATCH_ALL;
  return _eui.EuiSearchBar.Query.execute(filter, indexArray, {
    defaultFields: defaultFilterFields
  });
});
const getTotalItems = exports.getTotalItems = (0, _reselect.createSelector)(getFilteredIndices, filteredIndices => {
  return Object.keys(filteredIndices).length;
});
const getPager = exports.getPager = (0, _reselect.createSelector)(getTableState, getTotalItems, ({
  currentPage,
  pageSize
}, totalItems) => {
  return new _eui.Pager(totalItems, pageSize, currentPage);
});
const getPageOfIndices = exports.getPageOfIndices = (0, _reselect.createSelector)(getFilteredIndices, getTableState, getRowStatuses, getPager, (filteredIndices, tableState, rowStatuses, pager) => {
  const sortedIndexes = (0, _services.sortTable)(filteredIndices, tableState.sortField, tableState.isSortAscending, _extension_service.extensionsService);
  const {
    firstItemIndex,
    lastItemIndex
  } = pager;
  const pagedIndexes = sortedIndexes.slice(firstItemIndex, lastItemIndex + 1);
  return pagedIndexes.map(index => {
    if (index.status) {
      const status = _index_status_labels.indexStatusLabels[rowStatuses[index.name]] ||
      // user friendly version of row status
      rowStatuses[index.name] ||
      // row status
      _index_status_labels.indexStatusLabels[index.status] ||
      // user friendly version of index status
      index.status; // index status
      return {
        ...index,
        status
      };
    }
    return index;
  });
});
const getFilter = exports.getFilter = (0, _reselect.createSelector)(getTableState, ({
  filter
}) => filter);
const isSortAscending = exports.isSortAscending = (0, _reselect.createSelector)(getTableState, ({
  isSortAscending
}) => isSortAscending);
const getSortField = exports.getSortField = (0, _reselect.createSelector)(getTableState, ({
  sortField
}) => sortField);