"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyDetailsFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyDetailsFlyout = ({
  policy,
  onClose
}) => {
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "policyDetailsFlyout",
    size: "m",
    maxWidth: 550,
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    id: flyoutTitleId,
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement("h2", null, policy.name))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, policy.type && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.detailsFlyout.typeTitle', {
    defaultMessage: 'Type'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyTypeValue"
  }, policy.type)), policy.sourceIndices && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.detailsFlyout.sourceIndicesTitle', {
    defaultMessage: 'Source indices'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyIndicesValue"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textBreakWord"
  }, policy.sourceIndices.join(', ')))), policy.matchField && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.detailsFlyout.matchFieldTitle', {
    defaultMessage: 'Match field'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyMatchFieldValue"
  }, policy.matchField)), policy.enrichFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.detailsFlyout.enrichFieldsTitle', {
    defaultMessage: 'Enrich fields'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyEnrichFieldsValue"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textBreakWord"
  }, policy.enrichFields.join(', ')))), policy.query && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.detailsFlyout.queryTitle', {
    defaultMessage: 'Query'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: "json",
    isCopyable: true,
    allowFullScreen: true,
    value: JSON.stringify(policy.query, null, 2),
    "data-test-subj": "queryEditor",
    height: 250,
    options: {
      lineNumbers: 'off',
      tabSize: 2,
      automaticLayout: true
    },
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.detailsFlyout.queryAriaLabel', {
      defaultMessage: 'Enrich policy query editor'
    })
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left",
    "data-test-subj": "closeFlyoutButton"
  }, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.detailsFlyout.closeButton', {
    defaultMessage: 'Close'
  }))))));
};
exports.PolicyDetailsFlyout = PolicyDetailsFlyout;