"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepMappings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../../../../app_context");
var _mappings_editor = require("../../../mappings_editor");
var _shared_imports = require("../../../mappings_editor/shared_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepMappings = exports.StepMappings = /*#__PURE__*/_react.default.memo(({
  defaultValue = {},
  onChange,
  indexSettings,
  esDocsBase,
  esNodesPlugins,
  indexMode
}) => {
  const [mappings, setMappings] = (0, _react.useState)(defaultValue);
  const {
    docLinks
  } = (0, _app_context.useAppContext)();
  const onMappingsEditorUpdate = (0, _react.useCallback)(({
    isValid,
    getData,
    validate
  }) => {
    onChange({
      isValid,
      async validate() {
        return isValid === undefined ? await validate() : isValid;
      },
      getData
    });
  }, [onChange]);
  const onJsonLoaded = json => {
    setMappings(json);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "stepMappings"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "stepTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.formWizard.stepMappings.stepTitle",
    defaultMessage: "Mappings (optional)"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.formWizard.stepMappings.mappingsDescription",
    defaultMessage: "Define how to store and index documents."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_mappings_editor.LoadMappingsFromJsonButton, {
    onJson: onJsonLoaded,
    esNodesPlugins: esNodesPlugins
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: _shared_imports.documentationService.getMappingDocumentationLink(),
    target: "_blank",
    iconType: "question"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.formWizard.stepMappings.docsButtonLabel",
    defaultMessage: "Mapping docs"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_mappings_editor.MappingsEditor, {
    value: mappings,
    onChange: onMappingsEditorUpdate,
    indexSettings: indexSettings,
    docLinks: docLinks,
    esNodesPlugins: esNodesPlugins,
    indexMode: indexMode
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
});