"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplates = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _components = require("./components");
var _component_templates_list = require("./component_templates_list");
require("./component_templates.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Copied from https://stackoverflow.com/a/9310752
 */
function escapeRegExp(text) {
  return text.replace(/[-\[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
}
function fuzzyMatch(searchValue, text) {
  const pattern = `.*${searchValue.split('').map(escapeRegExp).join('.*')}.*`;
  const regex = new RegExp(pattern);
  return regex.test(text);
}
const i18nTexts = {
  filters: {
    settings: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesSelector.filters.indexSettingsLabel', {
      defaultMessage: 'Index settings'
    }),
    mappings: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesSelector.filters.mappingsLabel', {
      defaultMessage: 'Mappings'
    }),
    aliases: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesSelector.filters.aliasesLabel', {
      defaultMessage: 'Aliases'
    })
  },
  searchBoxPlaceholder: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesSelector.searchBox.placeholder', {
    defaultMessage: 'Search component templates'
  })
};
const getInitialFilters = () => ({
  settings: {
    name: i18nTexts.filters.settings,
    checked: 'off'
  },
  mappings: {
    name: i18nTexts.filters.mappings,
    checked: 'off'
  },
  aliases: {
    name: i18nTexts.filters.aliases,
    checked: 'off'
  }
});
const ComponentTemplates = ({
  isLoading,
  components,
  listItemProps
}) => {
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const [filters, setFilters] = (0, _react.useState)(getInitialFilters);
  const filteredComponents = (0, _react.useMemo)(() => {
    if (isLoading) {
      return [];
    }
    return components.filter(component => {
      if (filters.settings.checked === 'on' && !component.hasSettings) {
        return false;
      }
      if (filters.mappings.checked === 'on' && !component.hasMappings) {
        return false;
      }
      if (filters.aliases.checked === 'on' && !component.hasAliases) {
        return false;
      }
      if (searchValue.trim() === '') {
        return true;
      }
      const match = fuzzyMatch(searchValue, component.name);
      return match;
    }).sort((a, b) => {
      if (a.name < b.name) {
        return -1;
      } else if (a.name > b.name) {
        return 1;
      }
      return 0;
    });
  }, [isLoading, components, searchValue, filters]);
  const isSearchResultEmpty = filteredComponents.length === 0 && components.length > 0;
  if (isLoading) {
    return null;
  }
  const clearSearch = () => {
    setSearchValue('');
    setFilters(getInitialFilters());
  };
  const renderEmptyResult = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "search",
      title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplatesSelector.searchResult.emptyPromptTitle",
        defaultMessage: "No components match your search"
      })),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: clearSearch
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplatesSelector.searchResult.emptyPrompt.clearSearchButtonLabel",
        defaultMessage: "Clear search"
      })),
      "data-test-subj": "emptySearchResult"
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "componentTemplates",
    "data-test-subj": "componentTemplates"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "componentTemplates__header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    placeholder: i18nTexts.searchBoxPlaceholder,
    value: searchValue,
    onChange: e => {
      setSearchValue(e.target.value);
    },
    "aria-label": i18nTexts.searchBoxPlaceholder,
    className: "componentTemplates__searchBox",
    "data-test-subj": "componentTemplateSearchBox"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.FilterListButton, {
    filters: filters,
    onChange: setFilters
  })))), /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('eui-yScrollWithShadows componentTemplates__listWrapper', {
      'componentTemplates__listWrapper--is-empty': isSearchResultEmpty
    })
  }, isSearchResultEmpty ? renderEmptyResult() : /*#__PURE__*/_react.default.createElement(_component_templates_list.ComponentTemplatesList, {
    components: filteredComponents,
    listItemProps: listItemProps
  })));
};
exports.ComponentTemplates = ComponentTemplates;