"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexTemplatesFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/index-management-plugin/public");
var _shared_imports = require("../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexTemplatesFlyout = ({
  policyName,
  indexTemplates,
  close
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    services: {
      getUrlForApp
    }
  } = (0, _shared_imports.useKibana)();
  const getUrlForIndexTemplate = name => {
    return getUrlForApp('management', {
      path: `data/index_management${(0, _public.getTemplateDetailsLink)(name)}`
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: close,
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "data-test-subj": "indexTemplatesFlyoutHeader"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.policyTable.indexTemplatesFlyout.headerText",
    defaultMessage: "Index templates that apply {policyName}",
    values: {
      policyName
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    pagination: true
    // @ts-expect-error - EuiInMemoryTable wants an array of objects, but will accept strings if coerced
    ,
    items: indexTemplates !== null && indexTemplates !== void 0 ? indexTemplates : [],
    columns: [{
      name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.indexTemplatesTable.nameHeader', {
        defaultMessage: 'Index template name'
      }),
      // @ts-expect-error - EuiInMemoryTable wants an array of objects, but will accept strings if coerced
      render: value => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "indexTemplateLink",
          className: "eui-textBreakAll",
          href: getUrlForIndexTemplate(value)
        }, value);
      }
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: close,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.indexTemplatesFlyout.closeButtonLabel",
    defaultMessage: "Close"
  }))));
};
exports.IndexTemplatesFlyout = IndexTemplatesFlyout;