"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Welcome = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _full_screen_bg_css = require("@kbn/css-utils/public/full_screen_bg_css");
var _kibana_services = require("../kibana_services");
var _sample_data = require("./sample_data");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * The UI and related logic for the welcome screen that *should* show only
 * when it is enabled (the default) and there is no Kibana-consumed data
 * in Elasticsearch.
 */

/**
 * Shows a full-screen welcome page that gives helpful quick links to beginners.
 */
const Welcome = ({
  urlBasePath,
  onSkip
}) => {
  const services = (0, _kibana_services.getServices)();
  const euiShadowM = (0, _eui.useEuiShadow)('m');
  const kbnFullScreenBgCss = (0, _full_screen_bg_css.useKbnFullScreenBgCss)();
  const redirectToAddData = () => {
    services.application.navigateToApp('integrations', {
      path: '/browse'
    });
  };
  const onSampleDataDecline = () => {
    services.trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'sampleDataDecline');
    onSkip();
  };
  const onSampleDataConfirm = () => {
    services.trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'sampleDataConfirm');
    redirectToAddData();
  };
  (0, _react.useEffect)(() => {
    const hideOnEsc = e => {
      if (e.key === 'Escape') {
        onSkip();
      }
    };
    const {
      welcomeService
    } = services;
    services.trackUiMetric(_analytics.METRIC_TYPE.LOADED, 'welcomeScreenMount');
    document.addEventListener('keydown', hideOnEsc);
    welcomeService.onRendered();
    return () => {
      document.removeEventListener('keydown', hideOnEsc);
    };
  }, [onSkip, services]);
  const {
    welcomeService
  } = services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "homeWelcomeInterstitial",
    css: [styles, kbnFullScreenBgCss]
  }, /*#__PURE__*/_react.default.createElement("header", {
    className: "homeWelcome__header"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "homeWelcome__content eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "homeWelcome__logo",
    css: (0, _react2.css)`
                ${euiShadowM}
              `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoElastic",
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "home.welcomeTitle",
    defaultMessage: "Welcome to Elastic"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "homeWelcome__content"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_sample_data.SampleDataCard, {
    urlBasePath: urlBasePath,
    onConfirm: onSampleDataConfirm,
    onDecline: onSampleDataDecline
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), welcomeService.renderTelemetryNotice())))));
};
exports.Welcome = Welcome;
const styles = ({
  euiTheme
}) => (0, _react2.css)({
  '.homeWelcome__header': {
    padding: euiTheme.size.xl,
    zIndex: 10
  },
  '.homeWelcome__logo': {
    marginBottom: euiTheme.size.xl,
    display: 'inline-block'
  },
  '.homeWelcome__content': {
    margin: 'auto',
    maxWidth: (0, _eui.mathWithUnits)(euiTheme.size.xxxxl, x => x * 8),
    paddingLeft: euiTheme.size.xl,
    paddingRight: euiTheme.size.xl,
    zIndex: 10
  }
});