"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuitGuideModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../services/api.service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const QuitGuideModal = ({
  closeModal,
  currentGuide,
  telemetryGuideId,
  notifications
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const deactivateGuide = async () => {
    try {
      setIsLoading(true);
      await _api.apiService.deactivateGuide(currentGuide);
      closeModal();
    } catch (error) {
      setIsLoading(false);
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('guidedOnboarding.quitGuideModal.deactivateGuideError', {
          defaultMessage: 'Unable to update the guide. Wait a moment and try again.'
        }),
        text: error.message
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-label": "quitGuideModal",
    "data-test-subj": "onboarding--quitGuideModal",
    maxWidth: 448,
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('guidedOnboarding.quitGuideModal.modalTitle', {
    defaultMessage: 'Quit this guide?'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('guidedOnboarding.quitGuideModal.modalDescription', {
    defaultMessage: 'You can restart the setup guide any time from the Help menu.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `onboarding--cancelQuitGuideButton--${telemetryGuideId}`,
    onClick: closeModal
  }, _i18n.i18n.translate('guidedOnboarding.quitGuideModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton
  // Used for FS tracking and tests
  , {
    "data-test-subj": `onboarding--quitGuideButton--${telemetryGuideId}`,
    onClick: deactivateGuide,
    isLoading: isLoading,
    fill: true,
    color: "primary"
  }, _i18n.i18n.translate('guidedOnboarding.quitGuideModal.quitButtonLabel', {
    defaultMessage: 'Quit guide'
  }))));
};
exports.QuitGuideModal = QuitGuideModal;