"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectStyle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _styles = require("../../styles");
var _control_plane = require("./control_plane.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectStyle = ({
  colors,
  workspace
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    css: _styles.gphSidebarPanelStyles
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: _styles.gphSidebarHeaderStyles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "brush",
    size: "s"
  }), ' ', _i18n.i18n.translate('xpack.graph.sidebar.styleVerticesTitle', {
    defaultMessage: 'Style selected vertices'
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "form-group form-group-sm",
    css: _control_plane.gphFormGroupSmallStyles
  }, colors.map(c => {
    const onSelectColor = () => {
      workspace.colorSelected(c);
      workspace.changeHandler();
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "stopFilled",
      color: c,
      css: colorPickerIconStyles,
      "aria-hidden": "true",
      onClick: onSelectColor
    });
  })));
};
exports.SelectStyle = SelectStyle;
const colorPickerIconStyles = ({
  euiTheme
}) => (0, _react2.css)({
  margin: euiTheme.size.xs,
  cursor: 'pointer',
  '&:hover, &:focus': {
    transform: 'scale(1.4)'
  }
});