"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrillDowns = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _icon_renderer = require("../icon_renderer");
var _styles = require("../../styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DrillDowns = ({
  urlTemplates,
  openUrlTemplate
}) => {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", {
    css: _styles.gphSidebarHeaderStyles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "info"
  }), ' ', _i18n.i18n.translate('xpack.graph.sidebar.drillDownsTitle', {
    defaultMessage: 'Drill-downs'
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: _styles.gphSidebarPanelStyles
  }, urlTemplates.length === 0 && /*#__PURE__*/_react.default.createElement("p", {
    className: "help-block"
  }, _i18n.i18n.translate('xpack.graph.sidebar.drillDowns.noDrillDownsHelpText', {
    defaultMessage: 'Configure drill-downs from the settings menu'
  })), /*#__PURE__*/_react.default.createElement("ul", {
    className: "list-group"
  }, urlTemplates.map(urlTemplate => {
    const onOpenUrlTemplate = () => openUrlTemplate(urlTemplate);
    return /*#__PURE__*/_react.default.createElement("li", {
      className: "list-group-item"
    }, urlTemplate.icon && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
      icon: urlTemplate.icon,
      css: _styles.noUserSelectStyles
    }), ' '), /*#__PURE__*/_react.default.createElement("a", {
      "aria-hidden": "true",
      onClick: onOpenUrlTemplate
    }, urlTemplate.description));
  }))));
};
exports.DrillDowns = DrillDowns;