"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElasticConnectorsServerlessEnabled = getElasticConnectorsServerlessEnabled;
exports.getFilteredInstallPackages = getFilteredInstallPackages;
exports.getFilteredSearchPackages = getFilteredSearchPackages;
var _app_context = require("../app_context");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFilteredSearchPackages() {
  var _appContextService$ge, _appContextService$ge2, _appContextService$ge3, _appContextService$ge4, _appContextService$ge5, _appContextService$ge6;
  const isElasticConnectorsServerlessEnabled = getElasticConnectorsServerlessEnabled();
  const shouldFilterFleetServer = (_appContextService$ge = _app_context.appContextService.getConfig()) === null || _appContextService$ge === void 0 ? void 0 : (_appContextService$ge2 = _appContextService$ge.internal) === null || _appContextService$ge2 === void 0 ? void 0 : _appContextService$ge2.fleetServerStandalone;
  const filtered = ['profiler_collector', 'profiler_symbolizer'];
  if (!isElasticConnectorsServerlessEnabled) {
    filtered.push('elastic_connectors');
  }
  // Do not allow to search for Fleet server integration if configured to use  standalone fleet server
  if (shouldFilterFleetServer) {
    filtered.push(_constants.FLEET_SERVER_PACKAGE);
  }
  const excludePackages = (_appContextService$ge3 = (_appContextService$ge4 = _app_context.appContextService.getConfig()) === null || _appContextService$ge4 === void 0 ? void 0 : (_appContextService$ge5 = _appContextService$ge4.internal) === null || _appContextService$ge5 === void 0 ? void 0 : (_appContextService$ge6 = _appContextService$ge5.registry) === null || _appContextService$ge6 === void 0 ? void 0 : _appContextService$ge6.excludePackages) !== null && _appContextService$ge3 !== void 0 ? _appContextService$ge3 : [];
  return filtered.concat(excludePackages);
}
function getFilteredInstallPackages() {
  var _appContextService$ge7, _appContextService$ge8, _appContextService$ge9, _appContextService$ge10;
  const isElasticConnectorsServerlessEnabled = getElasticConnectorsServerlessEnabled();
  const filtered = [];
  if (!isElasticConnectorsServerlessEnabled) {
    filtered.push('elastic_connectors');
  }
  const excludePackages = (_appContextService$ge7 = (_appContextService$ge8 = _app_context.appContextService.getConfig()) === null || _appContextService$ge8 === void 0 ? void 0 : (_appContextService$ge9 = _appContextService$ge8.internal) === null || _appContextService$ge9 === void 0 ? void 0 : (_appContextService$ge10 = _appContextService$ge9.registry) === null || _appContextService$ge10 === void 0 ? void 0 : _appContextService$ge10.excludePackages) !== null && _appContextService$ge7 !== void 0 ? _appContextService$ge7 : [];
  return filtered.concat(excludePackages);
}
function getElasticConnectorsServerlessEnabled() {
  var _appContextService$ge11, _appContextService$ge12;
  const ELASTIC_CONNECTORS_SERVERLESS_PROJECT_TYPES = ['security', 'observability'];
  const cloud = _app_context.appContextService.getCloud();
  return (
    // is cloud and not serverless
    (cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled) && !(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled) ||
    // is serverless and project type is one of the supported
    (cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) && ELASTIC_CONNECTORS_SERVERLESS_PROJECT_TYPES.includes((_appContextService$ge11 = (_appContextService$ge12 = _app_context.appContextService.getCloud()) === null || _appContextService$ge12 === void 0 ? void 0 : _appContextService$ge12.serverless.projectType) !== null && _appContextService$ge11 !== void 0 ? _appContextService$ge11 : '')
  );
}