"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnprivilegedInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UnprivilegedInfo = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollmentFlyout.unprivilegedMessage",
    defaultMessage: "To install Elastic Agent without root privileges, add the {flag} flag to the {command} command below. For more information, see the {guideLink}",
    values: {
      flag: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "--unprivileged"),
      command: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "elastic-agent install"),
      guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.unprivilegedMode,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentEnrollmentFlyout.unprivilegedMessage.guideLink",
        defaultMessage: "Fleet and Elastic Agent Guide"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.UnprivilegedInfo = UnprivilegedInfo;