"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GoogleCloudShellInstructions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _google_cloud_shell_guide = require("./google_cloud_shell_guide");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GoogleCloudShellInstructions = ({
  cloudShellUrl,
  cloudShellCommand,
  projectId
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_google_cloud_shell_guide.GoogleCloudShellGuide, {
    commandText: cloudShellCommand,
    hasProjectId: !!projectId
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "launchGoogleCloudShellButtonAgentFlyoutTestId",
    color: "primary",
    fill: true,
    target: "_blank",
    iconSide: "left",
    iconType: "launch",
    fullWidth: true,
    href: cloudShellUrl
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.googleCloudShell.launchButton",
    defaultMessage: "Launch Google Cloud Shell"
  })));
};
exports.GoogleCloudShellInstructions = GoogleCloudShellInstructions;