"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstalledIntegrationsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _package_icon = require("../../../../../../../components/package_icon");
var _hooks = require("../../../../../../../hooks");
var _use_url_filters = require("../hooks/use_url_filters");
var _use_installed_integrations_actions = require("../hooks/use_installed_integrations_actions");
var _installation_version_status = require("./installation_version_status");
var _disabled_wrapper_tooltip = require("./disabled_wrapper_tooltip");
var _dashboards_cell = require("./dashboards_cell");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function wrapActionWithDisabledTooltip(action, disabled, tooltip) {
  return {
    ...action,
    ...(disabled ? {
      enabled: () => false,
      description: tooltip
    } : {})
  };
}
const InstalledIntegrationsTable = ({
  installedPackages,
  total,
  isLoading,
  pagination,
  selection
}) => {
  const authz = (0, _hooks.useAuthz)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    selectedItems,
    setSelectedItems
  } = selection;
  const {
    addViewPolicies
  } = (0, _use_url_filters.useViewPolicies)();
  const {
    actions: {
      bulkUninstallIntegrationsWithConfirmModal,
      bulkUpgradeIntegrationsWithConfirmModal
    }
  } = (0, _use_installed_integrations_actions.useInstalledIntegrationsActions)();
  const {
    setPagination
  } = pagination;
  const handleTablePagination = _react.default.useCallback(({
    page
  }) => {
    setPagination({
      currentPage: page.index + 1,
      pageSize: page.size
    });
  }, [setPagination]);
  const usedByAgentPolicy = item => {
    if (!item.packagePoliciesInfo) {
      return false;
    }
    const count = item.packagePoliciesInfo.count;
    return count > 0;
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.tableTotalCount",
    defaultMessage: 'Showing {total, plural, one {# integration} other {# integrations}}',
    values: {
      total
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isLoading,
    items: installedPackages,
    itemId: "name",
    rowProps: {
      'data-test-subj': 'installedIntegrationsTableRow'
    },
    pagination: {
      pageIndex: pagination.pagination.currentPage - 1,
      totalItemCount: total,
      pageSize: pagination.pagination.pageSize,
      showPerPageOptions: true,
      pageSizeOptions: pagination.pageSizeOptions
    },
    onChange: handleTablePagination,
    selection: {
      selectable: () => true,
      selected: selectedItems,
      onSelectionChange: newSelectedItems => {
        setSelectedItems(newSelectedItems);
      }
    },
    columns: [{
      name: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.integrationNameColumnTitle', {
        defaultMessage: 'Integration name'
      }),
      render: item => {
        const url = getHref('integration_details_overview', {
          pkgkey: `${item.name}-${item.installationInfo.version}`
        });
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: url
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_package_icon.TableIcon, {
          size: "m",
          icons: item.icons,
          packageName: item.name,
          version: item.version
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          "data-test-subj": `installedIntegrationsTable.integrationNameColumn.${item.name}`,
          grow: false
        }, item.title)));
      }
    }, {
      name: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.versionColumnTitle', {
        defaultMessage: 'Version'
      }),
      render: item => /*#__PURE__*/_react.default.createElement(_installation_version_status.InstallationVersionStatus, {
        item: item
      })
    }, {
      name: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.dashboardsColumnTitle', {
        defaultMessage: 'Dashboards'
      }),
      render: item => /*#__PURE__*/_react.default.createElement(_dashboards_cell.DashboardsCell, {
        package: item
      })
    }, {
      name: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.attachedPoliciesColumnTitle', {
        defaultMessage: 'Attached policies'
      }),
      width: '206px',
      render: item => {
        var _item$packagePolicies, _item$packagePolicies2;
        const policyCount = (_item$packagePolicies = (_item$packagePolicies2 = item.packagePoliciesInfo) === null || _item$packagePolicies2 === void 0 ? void 0 : _item$packagePolicies2.count) !== null && _item$packagePolicies !== void 0 ? _item$packagePolicies : 0;
        if (!policyCount) {
          return null;
        }
        const isDisabled = !authz.fleet.readAgentPolicies;
        return /*#__PURE__*/_react.default.createElement(_disabled_wrapper_tooltip.DisabledWrapperTooltip, {
          tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.epmInstalledIntegrations.agentPoliciesRequiredPermissionTooltip",
            defaultMessage: "You don't have permissions to view these policies. Contact your administrator."
          }),
          disabled: isDisabled
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => addViewPolicies(item.name),
          disabled: isDisabled
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epmInstalledIntegrations.viewAttachedPoliciesButton",
          defaultMessage: 'View {policyCount, plural, one {# policies} other {# policies}}',
          values: {
            policyCount
          }
        })));
      }
    },
    // TODO Actions are not yet implemented to be done in https://github.com/elastic/kibana/issues/209867
    {
      actions: [wrapActionWithDisabledTooltip({
        name: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.upgradeActionLabel', {
          defaultMessage: 'Upgrade'
        }),
        description: item => _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.upgradeActionDescription', {
          defaultMessage: 'Upgrade to {version}.',
          values: {
            version: item.version
          }
        }),
        icon: 'refresh',
        type: 'icon',
        onClick: item => bulkUpgradeIntegrationsWithConfirmModal([item]),
        enabled: item => item.ui.installation_status === 'upgrade_available' || item.ui.installation_status === 'upgrade_failed' || item.ui.installation_status === 'install_failed'
      }, !authz.integrations.upgradePackages, _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.upgradeIntegrationsRequiredPermissionTooltip', {
        defaultMessage: "You don't have permissions to upgrade integrations. Contact your administrator."
      })), wrapActionWithDisabledTooltip({
        name: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.viewPoliciesLabel', {
          defaultMessage: 'View policies'
        }),
        icon: 'search',
        type: 'icon',
        description: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.viewPoliciesLabel', {
          defaultMessage: 'View policies'
        }),
        onClick: item => addViewPolicies(item.name),
        enabled: item => {
          var _item$packagePolicies3, _item$packagePolicies4;
          return ((_item$packagePolicies3 = item === null || item === void 0 ? void 0 : (_item$packagePolicies4 = item.packagePoliciesInfo) === null || _item$packagePolicies4 === void 0 ? void 0 : _item$packagePolicies4.count) !== null && _item$packagePolicies3 !== void 0 ? _item$packagePolicies3 : 0) > 0;
        }
      }, !authz.fleet.readAgentPolicies, _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.agentPoliciesRequiredPermissionTooltip', {
        defaultMessage: "You don't have permissions to view these policies. Contact your administrator."
      })), {
        name: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.editIntegrationLabel', {
          defaultMessage: 'Edit integration'
        }),
        icon: 'pencil',
        type: 'icon',
        description: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.editIntegrationLabel', {
          defaultMessage: 'Edit integration'
        }),
        href: item => getHref('integration_details_overview', {
          pkgkey: `${item.name}-${item.installationInfo.version}`
        })
      }, wrapActionWithDisabledTooltip({
        name: _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.uninstallIntegrationLabel', {
          defaultMessage: 'Uninstall integration'
        }),
        icon: 'trash',
        type: 'icon',
        onClick: item => bulkUninstallIntegrationsWithConfirmModal([item]),
        enabled: item => !usedByAgentPolicy(item),
        description: item => _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.uninstallIntegrationLabel', {
          defaultMessage: usedByAgentPolicy(item) ? "You can't uninstall this integration because it is used by one or more agent policies" : 'Uninstall integration'
        })
      }, !authz.integrations.removePackages, _i18n.i18n.translate('xpack.fleet.epmInstalledIntegrations.removeIntegrationsRequiredPermissionTooltip', {
        defaultMessage: "You don't have permissions to remove integrations. Contact your administrator."
      }))]
    }]
  }));
};
exports.InstalledIntegrationsTable = InstalledIntegrationsTable;