"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmBulkUninstallModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmBulkUninstallModal = ({
  onClose,
  onConfirm,
  selectedItems
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const isSingleItem = selectedItems.length === 1;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: isSingleItem ? _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkUninstallModal.singleTitle', {
      defaultMessage: 'Uninstall {integrationName} ',
      values: {
        integrationName: selectedItems[0].title
      }
    }) : _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkUninstallModal.title', {
      defaultMessage: 'Uninstall {countIntegrations} integrations ',
      values: {
        countIntegrations: selectedItems.length
      }
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkUninstallModal.confirmButton', {
      defaultMessage: 'Uninstall {itemsCount, plural, one {integration} other {integrations}} ',
      values: {
        itemsCount: selectedItems.length
      }
    }),
    buttonColor: "danger",
    cancelButtonText: isSingleItem ? _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkUninstallModal.cancelSingleButton', {
      defaultMessage: 'Cancel'
    }) : _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkUninstallModal.cancelButton', {
      defaultMessage: 'Review and edit selection'
    }),
    onCancel: onClose,
    isLoading: isLoading,
    onConfirm: async () => {
      try {
        setIsLoading(true);
        await onConfirm();
        onClose();
      } catch (err) {
        setIsLoading(false);
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "info",
    title: _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkUninstallModal.calloutTitle', {
      defaultMessage: 'This action cannot be undone.'
    })
  }, isSingleItem ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.installedIntegrations.bulkUninstallModal.calloutContentSingleItem",
    defaultMessage: "All Kibana and Elasticsearch assets created by this integration will be also removed."
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.installedIntegrations.bulkUninstallModal.calloutContent",
    defaultMessage: "All Kibana and Elasticsearch assets created by these integrations will be also removed. Review and edit your selection if needed."
  })));
};
exports.ConfirmBulkUninstallModal = ConfirmBulkUninstallModal;