"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AvailablePackages = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../hooks");
var _package_list_grid = require("../../components/package_list_grid");
var _integration_preference = require("../../components/integration_preference");
var _category_facets = require("./category_facets");
var _ = require(".");
var _use_available_packages = require("./hooks/use_available_packages");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoEprCallout = ({
  statusCode
}) => {
  let titleMessage;
  let descriptionMessage;
  if (statusCode === 502) {
    titleMessage = _i18n.i18n.translate('xpack.fleet.epmList.eprUnavailableBadGatewayCalloutTitle', {
      defaultMessage: 'Kibana cannot reach the Elastic Package Registry, which provides Elastic Agent integrations\n'
    });
    descriptionMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmList.eprUnavailableCallouBdGatewaytTitleMessage",
      defaultMessage: "To view these integrations, configure a  {registryproxy} or host {onpremregistry}.",
      values: {
        registryproxy: /*#__PURE__*/_react.default.createElement(ProxyLink, null),
        onpremregistry: /*#__PURE__*/_react.default.createElement(OnPremLink, null)
      }
    });
  } else {
    titleMessage = _i18n.i18n.translate('xpack.fleet.epmList.eprUnavailable400500CalloutTitle', {
      defaultMessage: 'Kibana cannot connect to the Elastic Package Registry, which provides Elastic Agent integrations\n'
    });
    descriptionMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmList.eprUnavailableCallout400500TitleMessage",
      defaultMessage: "Ensure the {registryproxy} or {onpremregistry} is configured correctly, or try again later.",
      values: {
        registryproxy: /*#__PURE__*/_react.default.createElement(ProxyLink, null),
        onpremregistry: /*#__PURE__*/_react.default.createElement(OnPremLink, null)
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: titleMessage,
    iconType: "info",
    color: 'warning'
  }, /*#__PURE__*/_react.default.createElement("p", null, descriptionMessage));
};
function ProxyLink() {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.fleet.settingsFleetServerProxySettings,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.fleet.epmList.proxyLinkSnippedText', {
    defaultMessage: 'proxy server'
  }));
}
function OnPremLink() {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.fleet.onPremRegistry,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.fleet.epmList.onPremLinkSnippetText', {
    defaultMessage: 'your own registry'
  }));
}
const AvailablePackages = ({
  prereleaseIntegrationsEnabled
}) => {
  (0, _hooks.useBreadcrumbs)('integrations_all');
  const {
    initialSelectedCategory,
    selectedCategory,
    setCategory,
    allCategories,
    mainCategories,
    preference,
    setPreference,
    isLoading,
    isLoadingCategories,
    isLoadingAllPackages,
    isLoadingAppendCustomIntegrations,
    eprPackageLoadingError,
    eprCategoryLoadingError,
    searchTerm,
    setSearchTerm,
    setUrlandPushHistory,
    setUrlandReplaceHistory,
    filteredCards,
    availableSubCategories,
    selectedSubCategory,
    setSelectedSubCategory
  } = (0, _use_available_packages.useAvailablePackages)({
    prereleaseIntegrationsEnabled
  });
  const onCategoryChange = (0, _react.useCallback)(({
    id
  }) => {
    setCategory(id);
    setSearchTerm('');
    setSelectedSubCategory(undefined);
    setUrlandPushHistory({
      searchString: '',
      categoryId: id,
      subCategoryId: ''
    });
  }, [setCategory, setSearchTerm, setSelectedSubCategory, setUrlandPushHistory]);
  if (!isLoading && !(0, _.categoryExists)(initialSelectedCategory, allCategories)) {
    setUrlandReplaceHistory({
      searchString: searchTerm,
      categoryId: '',
      subCategoryId: ''
    });
    return null;
  }
  let controls = [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_integration_preference.IntegrationPreference, {
    initialType: preference,
    prereleaseIntegrationsEnabled: prereleaseIntegrationsEnabled,
    onChange: setPreference
  }))];
  if (mainCategories) {
    controls = [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-yScrollWithShadows"
    }, /*#__PURE__*/_react.default.createElement(_category_facets.CategoryFacets, {
      isLoading: isLoading,
      categories: mainCategories,
      selectedCategory: selectedCategory,
      onCategoryChange: onCategoryChange
    })), ...controls];
  }
  let noEprCallout;
  if (eprPackageLoadingError || eprCategoryLoadingError) {
    const error = eprPackageLoadingError || eprCategoryLoadingError;
    noEprCallout = /*#__PURE__*/_react.default.createElement(NoEprCallout, {
      statusCode: error === null || error === void 0 ? void 0 : error.statusCode
    });
  }
  return /*#__PURE__*/_react.default.createElement(_package_list_grid.PackageListGrid, {
    isLoading: isLoadingCategories || isLoadingAllPackages || isLoadingAppendCustomIntegrations,
    controls: controls,
    searchTerm: searchTerm,
    setSearchTerm: setSearchTerm,
    list: filteredCards,
    selectedCategory: selectedCategory,
    setCategory: setCategory,
    categories: mainCategories,
    setUrlandReplaceHistory: setUrlandReplaceHistory,
    setUrlandPushHistory: setUrlandPushHistory,
    callout: noEprCallout,
    showCardLabels: false,
    availableSubCategories: availableSubCategories,
    selectedSubCategory: selectedSubCategory,
    setSelectedSubCategory: setSelectedSubCategory,
    showMissingIntegrationMessage: true
  });
};
exports.AvailablePackages = AvailablePackages;