"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmPackageInstall = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _transform_install_as_current_user_callout = require("../../../../../../../components/transform_install_as_current_user_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmPackageInstall = props => {
  const {
    onCancel,
    onConfirm,
    packageName,
    numOfAssets,
    numOfTransformAssets
  } = props;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrations.settings.confirmInstallModal.installTitle",
      defaultMessage: "Install {packageName}",
      values: {
        packageName
      }
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrations.settings.confirmInstallModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrations.settings.confirmInstallModal.installButtonLabel",
      defaultMessage: "Install {packageName}",
      values: {
        packageName
      }
    }),
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrations.settings.confirmInstallModal.installCalloutTitle",
      defaultMessage: "This action will install {numOfAssets} assets",
      values: {
        numOfAssets
      }
    })
  }), numOfTransformAssets > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_transform_install_as_current_user_callout.TransformInstallWithCurrentUserPermissionCallout, {
    count: numOfTransformAssets
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.confirmInstallModal.installDescription",
    defaultMessage: "Kibana assets will be installed in the current Space (Default) and will only be accessible to users who have permission to view this Space. Elasticsearch assets are installed globally and will be accessible to all Kibana users."
  })));
};
exports.ConfirmPackageInstall = ConfirmPackageInstall;