"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmOpenUnverifiedModal = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmOpenUnverifiedModal = ({
  onCancel,
  onConfirm,
  pkgName,
  docLinks
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textBreakWord"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.ConfirmOpenUnverifiedModal.title",
      defaultMessage: "View unverified integration?"
    })),
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.ConfirmOpenUnverifiedModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.ConfirmOpenUnverifiedModal.confirmButtonLabel",
      defaultMessage: "View anyway"
    }),
    buttonColor: "danger",
    "data-test-subj": "ConfirmOpenUnverifiedModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.ConfirmOpenUnverifiedModal.calloutTitleWithPkg', {
      defaultMessage: 'Integration {pkgName} has failed verification',
      values: {
        pkgName
      }
    }),
    color: "warning",
    iconType: "warning",
    children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.ConfirmOpenUnverifiedModal.calloutBody",
      defaultMessage: "This integration contains an unsigned package of unknown authenticity and could contain malicious files. Learn more about {learnMoreLink}.",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          external: true,
          href: docLinks.links.fleet.packageSignatures
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.ConfirmOpenUnverifiedModal.learnMoreLink",
          defaultMessage: "package signatures"
        }))
      }
    })
  }));
};
exports.ConfirmOpenUnverifiedModal = ConfirmOpenUnverifiedModal;