"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeModalWarningCallout = exports.AgentUpgradeAgentModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _gt = _interopRequireDefault(require("semver/functions/gt"));
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _services = require("../../../../../../../common/services");
var _agent_status = require("../../../../../../../common/services/agent_status");
var _hooks = require("../../../../hooks");
var _is_agent_upgradeable = require("../../../../../../../common/services/is_agent_upgradeable");
var _constants = require("./constants");
var _hooks2 = require("./hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getVersion = version => {
  var _version$;
  return (_version$ = version[0]) === null || _version$ === void 0 ? void 0 : _version$.value;
};
function isVersionUnsupported(version) {
  if (!version) {
    return false;
  }
  return (0, _lt.default)(version, _constants.ROLLING_UPGRADE_MINIMUM_SUPPORTED_VERSION);
}
const AgentUpgradeAgentModal = ({
  onClose,
  agents,
  agentCount,
  isScheduled = false,
  isUpdating = false
}) => {
  var _versionOptions$, _config$internal;
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    notifications,
    docLinks
  } = (0, _hooks.useStartServices)();
  const kibanaVersion = (0, _hooks.useKibanaVersion)() || '';
  const config = (0, _hooks.useConfig)();
  const [isSubmitting, setIsSubmitting] = (0, _react.useState)(false);
  const [errors, setErrors] = (0, _react.useState)();
  const [availableVersions, setVersions] = (0, _react.useState)([]);
  const isSingleAgent = Array.isArray(agents) && agents.length === 1;
  const isSmallBatch = agentCount <= 10;
  const isAllAgents = agents === '';
  const [updatingAgents, setUpdatingAgents] = (0, _react.useState)(0);
  const [updatingQuery, setUpdatingQuery] = (0, _react.useState)('');
  const [fleetServerAgents, setFleetServerAgents] = (0, _react.useState)([]);
  const QUERY_STUCK_UPDATING = `status:updating AND upgrade_started_at:* AND NOT upgraded_at:* AND upgrade_started_at < now-${_agent_status.AGENT_UPDATING_TIMEOUT_HOURS}h`;
  const EMPTY_VALUE = (0, _react.useMemo)(() => ({
    label: '',
    value: ''
  }), []);
  const [isInvalid, setIsInvalid] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const getStuckUpdatingAgentCount = async agentsOrQuery => {
      let newQuery;
      // find updating agents from array
      if (Array.isArray(agentsOrQuery) && agentsOrQuery.length > 0) {
        if (agentsOrQuery.length === 0) {
          return;
        }
        const newAgents = agentsOrQuery.filter(agent => (0, _agent_status.isStuckInUpdating)(agent));
        const updatingCount = newAgents.length;
        setUpdatingAgents(updatingCount);
        setUpdatingQuery(newAgents);
        return;
      } else if (typeof agentsOrQuery === 'string' && agentsOrQuery !== '') {
        newQuery = [`(${agentsOrQuery})`, QUERY_STUCK_UPDATING].join(' AND ');
      } else {
        newQuery = QUERY_STUCK_UPDATING;
      }
      setUpdatingQuery(newQuery);

      // if selection is a query, do an api call to get updating agents
      try {
        var _res$data$results$upd, _res$data, _res$data$results;
        const res = await (0, _hooks.sendGetAgentStatus)({
          kuery: newQuery
        });
        setUpdatingAgents((_res$data$results$upd = res === null || res === void 0 ? void 0 : (_res$data = res.data) === null || _res$data === void 0 ? void 0 : (_res$data$results = _res$data.results) === null || _res$data$results === void 0 ? void 0 : _res$data$results.updating) !== null && _res$data$results$upd !== void 0 ? _res$data$results$upd : 0);
      } catch (err) {
        return;
      }
    };
    if (!isUpdating) return;
    getStuckUpdatingAgentCount(agents);
  }, [isUpdating, setUpdatingQuery, QUERY_STUCK_UPDATING, agents]);
  (0, _react.useEffect)(() => {
    const getVersions = async () => {
      try {
        var _res$data2;
        const res = await (0, _hooks.sendGetAgentsAvailableVersions)();
        // if the endpoint returns an error, use the fallback versions
        const versionsList = res !== null && res !== void 0 && (_res$data2 = res.data) !== null && _res$data2 !== void 0 && _res$data2.items ? res.data.items : _constants.FALLBACK_VERSIONS;
        setVersions(versionsList);
      } catch (err) {
        return;
      }
    };
    getVersions();
  }, [kibanaVersion]);
  (0, _react.useEffect)(() => {
    const fetchFleetServerAgents = async () => {
      try {
        const {
          allFleetServerAgents
        } = await (0, _hooks.sendGetAllFleetServerAgents)();
        setFleetServerAgents(allFleetServerAgents);
      } catch (error) {
        return;
      }
    };
    fetchFleetServerAgents();
  }, []);
  const minVersion = (0, _react.useMemo)(() => {
    if (!Array.isArray(agents)) {
      // when agent is a query, don't set minVersion, so the versions are available to select
      if (typeof agents === 'string') {
        return undefined;
      }
      return (0, _services.getMinVersion)(availableVersions);
    }
    const versions = agents.map(agent => {
      var _agent$local_metadata, _agent$local_metadata2, _agent$local_metadata3;
      return (_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : (_agent$local_metadata2 = _agent$local_metadata.elastic) === null || _agent$local_metadata2 === void 0 ? void 0 : (_agent$local_metadata3 = _agent$local_metadata2.agent) === null || _agent$local_metadata3 === void 0 ? void 0 : _agent$local_metadata3.version;
    });
    return (0, _services.getMinVersion)(versions);
  }, [agents, availableVersions]);
  const versionOptions = (0, _react.useMemo)(() => {
    const displayVersions = minVersion ? availableVersions.filter(v => (0, _gt.default)(v, minVersion) || (0, _is_agent_upgradeable.differsOnlyInPatch)(v, minVersion, false)) : availableVersions;
    const options = displayVersions.map(option => ({
      label: option,
      value: option
    }));
    if (options.length === 0) {
      return [EMPTY_VALUE];
    }
    return options;
  }, [availableVersions, minVersion, EMPTY_VALUE]);
  const noVersions = !availableVersions || ((_versionOptions$ = versionOptions[0]) === null || _versionOptions$ === void 0 ? void 0 : _versionOptions$.value) === '';
  const maintenanceOptions = _constants.MAINTENANCE_VALUES.map(option => ({
    label: option === 0 ? _i18n.i18n.translate('xpack.fleet.upgradeAgents.noMaintenanceWindowOption', {
      defaultMessage: 'Immediately'
    }) : _i18n.i18n.translate('xpack.fleet.upgradeAgents.hourLabel', {
      defaultMessage: '{option} {count, plural, one {hour} other {hours}}',
      values: {
        option,
        count: option === 1
      }
    }),
    value: option === 0 ? 0 : option * 3600
  }));
  const preselected = [{
    label: kibanaVersion,
    value: kibanaVersion
  }];
  const [selectedVersion, setSelectedVersion] = (0, _react.useState)(preselected);

  // latest agent version might be earlier than kibana version
  const latestAgentVersion = (0, _hooks.useAgentVersion)();
  (0, _react.useEffect)(() => {
    if (latestAgentVersion) {
      setSelectedVersion([{
        label: latestAgentVersion,
        value: latestAgentVersion
      }]);
    }
  }, [latestAgentVersion]);
  const warningMessage = (0, _react.useMemo)(() => {
    var _selectedVersion$, _selectedVersion$2;
    if (isSingleAgent && (_selectedVersion$ = selectedVersion[0]) !== null && _selectedVersion$ !== void 0 && _selectedVersion$.value && !(0, _is_agent_upgradeable.isAgentUpgradeableToVersion)(agents[0], selectedVersion[0].value)) {
      return `The selected agent is not upgradeable: ${(0, _is_agent_upgradeable.getNotUpgradeableMessage)(agents[0], latestAgentVersion, selectedVersion[0].value)}`;
    }
    if ((_selectedVersion$2 = selectedVersion[0]) !== null && _selectedVersion$2 !== void 0 && _selectedVersion$2.value && !(0, _services.isAgentVersionLessThanFleetServer)(selectedVersion[0].value, fleetServerAgents)) {
      return `Please choose another version. ${(0, _services.getFleetServerVersionMessage)(selectedVersion[0].value, fleetServerAgents)}`;
    }
  }, [agents, fleetServerAgents, isSingleAgent, latestAgentVersion, selectedVersion]);
  const semverErrors = (0, _react.useMemo)(() => {
    if (!selectedVersion[0].value) return undefined;
    if (!(0, _valid.default)(selectedVersion[0].value)) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.upgradeAgents.invalidSemverError",
        defaultMessage: "Invalid version, please use a valid semver version, e.g. 8.14.0"
      });
    }
  }, [selectedVersion]);
  const [selectedMaintenanceWindow, setSelectedMaintenanceWindow] = (0, _react.useState)([isSmallBatch ? maintenanceOptions[0] : maintenanceOptions[1]]);
  const {
    startDatetime,
    onChangeStartDateTime,
    initialDatetime,
    minTime,
    maxTime
  } = (0, _hooks2.useScheduleDateTime)();
  const isSingleAgentFleetServer = isSingleAgent && fleetServerAgents.map(agent => agent.id).includes(agents[0].id);
  const isSubmitButtonDisabled = (0, _react.useMemo)(() => {
    if (!isSubmitting && isUpdating && isSingleAgent && (0, _agent_status.isStuckInUpdating)(agents[0])) return false;
    return isSubmitting || isUpdating && updatingAgents === 0 || !selectedVersion[0].value || !(0, _valid.default)(selectedVersion[0].value) || isSingleAgent && !(0, _is_agent_upgradeable.isAgentUpgradeableToVersion)(agents[0], selectedVersion[0].value) || isSingleAgent && !isSingleAgentFleetServer && !(0, _services.isAgentVersionLessThanFleetServer)(selectedVersion[0].value, fleetServerAgents);
  }, [agents, fleetServerAgents, isSingleAgent, isSubmitting, isUpdating, selectedVersion, updatingAgents, isSingleAgentFleetServer]);
  async function onSubmit() {
    var _selectedMaintenanceW;
    const version = getVersion(selectedVersion);
    const rolloutOptions = {
      rollout_duration_seconds: selectedMaintenanceWindow.length > 0 && ((_selectedMaintenanceW = selectedMaintenanceWindow[0]) === null || _selectedMaintenanceW === void 0 ? void 0 : _selectedMaintenanceW.value) > 0 ? selectedMaintenanceWindow[0].value : undefined,
      start_time: startDatetime.toISOString()
    };
    try {
      setIsSubmitting(true);
      const getQuery = agentsOrQuery => Array.isArray(agentsOrQuery) ? agentsOrQuery.map(agent => agent.id) : agentsOrQuery;
      const {
        error
      } = isSingleAgent && !isScheduled && (0, _is_agent_upgradeable.isAgentUpgradeableToVersion)(agents[0], selectedVersion[0].value) ? await (0, _hooks.sendPostAgentUpgrade)(agents[0].id, {
        version,
        force: isUpdating
      }) : await (0, _hooks.sendPostBulkAgentUpgrade)({
        version,
        agents: getQuery(isUpdating ? updatingQuery : agents),
        force: isUpdating,
        includeInactive: true,
        ...rolloutOptions
      });
      if (error) {
        if ((error === null || error === void 0 ? void 0 : error.statusCode) === 400) {
          setErrors(error === null || error === void 0 ? void 0 : error.message);
        }
        throw error;
      }
      setIsSubmitting(false);
      notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.upgradeAgents.successNotificationTitle', {
        defaultMessage: 'Upgrading agent(s)'
      }));
      onClose();
    } catch (error) {
      setIsSubmitting(false);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.upgradeAgents.fatalErrorNotificationTitle', {
          defaultMessage: `Error upgrading {isAllAgents, select,
            true {all selected agents}
            other {{count, plural, one {agent} other {# agents}}}
          }`,
          values: {
            isAllAgents,
            count: agentCount
          }
        })
      });
    }
  }
  const onCreateOption = searchValue => {
    const normalizedSearchValue = searchValue.trim();
    const newOption = {
      label: normalizedSearchValue,
      value: normalizedSearchValue
    };
    setSelectedVersion([newOption]);
    setIsInvalid(!normalizedSearchValue);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "agentUpgradeModal",
    "aria-labelledby": confirmModalTitleId,
    titleProps: {
      id: confirmModalTitleId
    },
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSingleAgent ? isUpdating ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.upgradeAgents.restartUpgradeSingleTitle",
      defaultMessage: "Restart upgrade"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.upgradeAgents.upgradeSingleTitle",
      defaultMessage: "Upgrade agent"
    }) : isScheduled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.upgradeAgents.scheduleUpgradeMultipleTitle",
      defaultMessage: "Schedule upgrade for {isAllAgents, select, true {all selected agents} other {{count, plural, one {agent} other {# agents}}} }",
      values: {
        isAllAgents,
        count: agentCount
      }
    }) : isUpdating ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.upgradeAgents.restartUpgradeMultipleTitle",
      defaultMessage: "Restart upgrade on {updating} out of {isAllAgents, select, true {all agents} other {{count, plural, one {agent} other {# agents}}} } stuck in updating",
      values: {
        isAllAgents,
        count: agentCount,
        updating: updatingAgents
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.upgradeAgents.upgradeMultipleTitle",
      defaultMessage: "Upgrade {isAllAgents, select, true {all selected agents} other {{count, plural, one {agent} other {# agents}}} }",
      values: {
        isAllAgents,
        count: agentCount
      }
    })),
    onCancel: onClose,
    onConfirm: onSubmit,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.upgradeAgents.cancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    confirmButtonDisabled: isSubmitButtonDisabled,
    confirmButtonText: isSingleAgent ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.upgradeAgents.confirmSingleButtonLabel",
      defaultMessage: "Upgrade agent"
    }) : isScheduled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.upgradeAgents.confirmScheduleMultipleButtonLabel",
      defaultMessage: "Schedule"
    }) : isUpdating ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.upgradeAgents.restartConfirmMultipleButtonLabel",
      defaultMessage: "Restart upgrade {isAllAgents, select, true {all selected agents} other {{count, plural, one {agent} other {# agents}}} }",
      values: {
        isAllAgents: typeof updatingAgents === 'boolean',
        count: updatingAgents
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.upgradeAgents.confirmMultipleButtonLabel",
      defaultMessage: "Upgrade {isAllAgents, select, true {all selected agents} other {{count, plural, one {agent} other {# agents}}} }",
      values: {
        isAllAgents,
        count: agentCount
      }
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, noVersions ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradeAgents.noVersionsText",
    defaultMessage: "No newer versions found to upgrade to. You may type in a custom version."
  }) : isSingleAgent ? warningMessage ? /*#__PURE__*/_react.default.createElement(UpgradeModalWarningCallout, {
    warningMessage: warningMessage
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradeAgents.upgradeSingleDescription",
    defaultMessage: "This action will upgrade the agent running on ''{hostName}''{version}. This action can not be undone. Are you sure you wish to continue?",
    values: {
      hostName: agents[0].local_metadata.host.hostname,
      version: selectedVersion[0].value ? ' to version ' + getVersion(selectedVersion) : ''
    }
  })), isUpdating && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("em", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradeAgents.upgradeSingleTimeout",
    defaultMessage: "Note that you may only restart an upgrade every {minutes} minutes to ensure that the upgrade will not be rolled back. {learnMore}",
    values: {
      minutes: _services.AGENT_UPGRADE_COOLDOWN_IN_MIN,
      learnMore: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.upgradeElasticAgent,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.upgradeAgentsDocLink",
        defaultMessage: "Learn more"
      })))
    }
  })))) : warningMessage ? /*#__PURE__*/_react.default.createElement(UpgradeModalWarningCallout, {
    warningMessage: warningMessage
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradeAgents.upgradeMultipleDescription",
    defaultMessage: "This action will upgrade multiple agents{version}. This action can not be undone. Are you sure you wish to continue?",
    values: {
      version: selectedVersion[0].value ? ' to version ' + getVersion(selectedVersion) : ''
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.fleet.upgradeAgents.chooseVersionLabel', {
      defaultMessage: 'Upgrade version'
    }),
    fullWidth: true,
    isInvalid: isInvalid || !!semverErrors,
    error: isInvalid ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.upgradeAgents.versionRequiredText",
      defaultMessage: "Version is required"
    }) : !!semverErrors ? semverErrors : undefined
  }, noVersions ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    placeholder: "Enter version",
    value: selectedVersion[0].value,
    "data-test-subj": "agentUpgradeModal.VersionInput",
    onChange: e => {
      const newValue = e.target.value;
      setSelectedVersion([{
        label: newValue,
        value: newValue
      }]);
    },
    isInvalid: !!semverErrors
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "agentUpgradeModal.VersionCombobox",
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    options: versionOptions,
    isClearable: true,
    selectedOptions: selectedVersion,
    onChange: selected => {
      if (!selected.length) {
        setSelectedVersion([EMPTY_VALUE]);
        setIsInvalid(true);
      } else {
        setSelectedVersion(selected);
        setIsInvalid(false);
      }
    },
    onCreateOption: config !== null && config !== void 0 && (_config$internal = config.internal) !== null && _config$internal !== void 0 && _config$internal.onlyAllowAgentUpgradeToKnownVersions ? undefined : onCreateOption,
    customOptionText: "Use custom agent version {searchValue} (not recommended)",
    isInvalid: isInvalid
  })), !isSingleAgent && Array.isArray(agents) && agents.some(agent => {
    var _agent$local_metadata4, _agent$local_metadata5, _agent$local_metadata6;
    return isVersionUnsupported((_agent$local_metadata4 = agent.local_metadata) === null || _agent$local_metadata4 === void 0 ? void 0 : (_agent$local_metadata5 = _agent$local_metadata4.elastic) === null || _agent$local_metadata5 === void 0 ? void 0 : (_agent$local_metadata6 = _agent$local_metadata5.agent) === null || _agent$local_metadata6 === void 0 ? void 0 : _agent$local_metadata6.version);
  }) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.upgradeAgents.warningCallout",
      defaultMessage: "Rolling upgrades are only available for Elastic Agent versions {version} and higher",
      values: {
        version: /*#__PURE__*/_react.default.createElement("strong", null, _constants.ROLLING_UPGRADE_MINIMUM_SUPPORTED_VERSION)
      }
    })
  })) : null, isScheduled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.fleet.upgradeAgents.startTimeLabel', {
      defaultMessage: 'Scheduled date and time'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    "data-test-subj": "agentUpgradeModal.startTimeDatePicker",
    fullWidth: true,
    required: true,
    showTimeSelect: true,
    selected: startDatetime,
    minDate: initialDatetime,
    minTime: minTime,
    maxTime: maxTime,
    onChange: onChangeStartDateTime
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !isSingleAgent ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.fleet.upgradeAgents.rolloutPeriodLabel', {
      defaultMessage: 'Rollout period'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.fleet.upgradeAgents.rolloutPeriodTooltip', {
        defaultMessage: 'Define the rollout period for upgrades to your Elastic Agents. Any agents that are offline during this period will be upgraded when they come back online.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info"
    })))),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "agentUpgradeModal.MaintenanceCombobox",
    fullWidth: true,
    isClearable: false,
    singleSelection: {
      asPlainText: true
    },
    options: maintenanceOptions,
    selectedOptions: selectedMaintenanceWindow,
    onChange: selected => {
      if (!selected.length) {
        return;
      }
      setSelectedMaintenanceWindow(selected);
    }
  })) : null, errors ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: _i18n.i18n.translate('xpack.fleet.upgradeAgents.warningCalloutErrors', {
      defaultMessage: 'Error upgrading the selected {count, plural, one {agent} other {{count} agents}}',
      values: {
        count: isSingleAgent
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradeAgents.warningCalloutErrorMessage",
    defaultMessage: "{originalMessage}. {learnMore}",
    values: {
      originalMessage: errors,
      learnMore: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.upgradeElasticAgent,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.upgradeAgentsDocLink",
        defaultMessage: "Learn more"
      })))
    }
  }))) : null);
};
exports.AgentUpgradeAgentModal = AgentUpgradeAgentModal;
const UpgradeModalWarningCallout = ({
  warningMessage
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "agentUpgradeModal.notUpgradeableCallout",
    color: "warning",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.upgradeAgents.notUpgradeable",
      defaultMessage: "Warning"
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradeAgents.notUpgradeableMsg",
    defaultMessage: "{reason} {learnMore}",
    values: {
      reason: warningMessage,
      learnMore: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.upgradeElasticAgent,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.upgradeAgentsDocLink",
        defaultMessage: "Learn more"
      })))
    }
  }));
};
exports.UpgradeModalWarningCallout = UpgradeModalWarningCallout;