"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupTechnologySelector = exports.SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../../../hooks");
var _types = require("../../../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ = exports.SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ = 'setup-technology-selector';
const SetupTechnologySelector = ({
  disabled,
  allowedSetupTechnologies,
  setupTechnology,
  onSetupTechnologyChange,
  isAgentlessDefault
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.setupTechnology.setupTechnologyLabel",
      defaultMessage: "Deployment options"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.setupTechnology.setupTechnologyDescription",
      defaultMessage: "Select a deployment mode for this integration."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    disabled: disabled,
    name: "SetupTechnologySelector",
    "data-test-subj": SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ,
    options: [{
      id: `SetupTechnologySelector_${_types.SetupTechnology.AGENTLESS}`,
      value: _types.SetupTechnology.AGENTLESS,
      disabled: !allowedSetupTechnologies.includes(_types.SetupTechnology.AGENTLESS),
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentlessInputDisplay",
        defaultMessage: "Agentless"
      }), ' ', isAgentlessDefault ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentlessDeployment.recommendedBadge",
        defaultMessage: "Recommended"
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
        href: docLinks.links.fleet.agentlessIntegrations,
        target: "_blank",
        label: 'Beta',
        size: "s",
        tooltipContent: "This module is not yet GA. Please help us by reporting any bugs.",
        alignment: "middle"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentlessInputDescription",
        defaultMessage: "Set up the integration without an agent"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs"
      }))
    }, {
      id: `SetupTechnologySelector_${_types.SetupTechnology.AGENT_BASED}`,
      value: _types.SetupTechnology.AGENT_BASED,
      disabled: !allowedSetupTechnologies.includes(_types.SetupTechnology.AGENT_BASED),
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentbasedInputDisplay",
        defaultMessage: "Agent-based"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentbasedInputDescription",
        defaultMessage: "Deploy an Elastic Agent into your cloud environment"
      }))))
    }],
    idSelected: `SetupTechnologySelector_${setupTechnology}`,
    onChange: (id, value) => {
      onSetupTechnologyChange(value);
    }
  }));
};
exports.SetupTechnologySelector = SetupTechnologySelector;