"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostInstallAddAgentModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../../../../../../components");
var _hooks = require("../../../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toTitleCase = str => str.charAt(0).toUpperCase() + str.substr(1);
const PostInstallAddAgentModal = ({
  onConfirm,
  onCancel,
  packageInfo
}) => {
  const isGuidedOnboardingActive = (0, _hooks.useIsGuidedOnboardingActive)(packageInfo.name);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "postInstallAddAgentModal",
    onClose: onCancel,
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "confirmModalTitleText",
    id: modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallAddAgentModal",
    defaultMessage: "{packageName} integration added",
    values: {
      packageName: toTitleCase(packageInfo.title)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "confirmModalBodyText"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallAddAgentModalDescription",
    defaultMessage: "To complete this integration, add {elasticAgent} to your hosts to collect data and send it to Elastic Stack.",
    values: {
      elasticAgent: /*#__PURE__*/_react.default.createElement("strong", null, "Elastic Agent")
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "confirmModalCancelButton",
    onClick: onCancel
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallAddAgentModalCancelButtonLabel",
    defaultMessage: "Add Elastic Agent later"
  })), /*#__PURE__*/_react.default.createElement(_components.WithGuidedOnboardingTour, {
    packageKey: packageInfo.name,
    tourType: "agentModalButton",
    isTourVisible: isGuidedOnboardingActive,
    tourPosition: "downCenter",
    tourOffset: -20
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "confirmModalConfirmButton",
    onClick: onConfirm,
    fill: true,
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallAddAgentModalConfirmButtonLabel",
    defaultMessage: "Add Elastic Agent to your hosts"
  })))));
};
exports.PostInstallAddAgentModal = PostInstallAddAgentModal;