"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallElasticAgentManagedPageStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _components = require("../../../../../../../components");
var _hooks = require("../../../../../../../../../hooks");
var _ = require("../..");
var _steps = require("../../../../../../../../../components/agent_enrollment_flyout/steps");
var _enrollment_instructions = require("../../../../../../../../../components/enrollment_instructions");
var _run_k8s_apply_command_step = require("../../../../../../../../../components/agent_enrollment_flyout/steps/run_k8s_apply_command_step");
var _services = require("../../../../../../../../../../common/services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InstallElasticAgentManagedPageStep = props => {
  var _agentPolicy$package_, _agentPolicy$package_2;
  const {
    cancelUrl,
    onNext,
    cancelClickHandler,
    setIsManaged,
    agentPolicy,
    enrollmentAPIKey,
    fleetServerHost,
    fleetProxy,
    enrolledAgentIds
  } = props;
  const core = (0, _hooks.useStartServices)();
  const {
    docLinks
  } = core;
  const link = docLinks.links.fleet.troubleshooting;
  const agentVersion = (0, _hooks.useAgentVersion)();
  const [commandCopied, setCommandCopied] = (0, _react.useState)(false);
  const [applyCommandCopied, setApplyCommandCopied] = (0, _react.useState)(false);
  if (!enrollmentAPIKey) {
    return /*#__PURE__*/_react.default.createElement(_components.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",
        defaultMessage: "Error loading package information"
      }),
      error: 'Enrollment API key not found'
    });
  }
  const isK8s = props.packageInfo.name === 'kubernetes' ? 'IS_KUBERNETES_MULTIPAGE' : 'IS_NOT_KUBERNETES';
  const showInstallServers = (0, _services.hasInstallServersInputs)((_agentPolicy$package_ = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.package_policies) !== null && _agentPolicy$package_ !== void 0 ? _agentPolicy$package_ : []);
  const installManagedCommands = (0, _enrollment_instructions.ManualInstructions)({
    apiKey: enrollmentAPIKey.api_key,
    fleetProxy,
    fleetServerHost,
    agentVersion: agentVersion || '',
    showInstallServers
  });
  const steps = [(0, _steps.InstallManagedAgentStep)({
    installCommand: installManagedCommands,
    apiKeyData: {
      item: enrollmentAPIKey
    },
    enrollToken: enrollmentAPIKey.api_key,
    isK8s,
    selectedApiKeyId: enrollmentAPIKey.id,
    isComplete: commandCopied || !!enrolledAgentIds.length,
    fullCopyButton: true,
    fleetServerHost,
    onCopy: () => setCommandCopied(true),
    rootIntegrations: (0, _services.getRootIntegrations)((_agentPolicy$package_2 = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.package_policies) !== null && _agentPolicy$package_2 !== void 0 ? _agentPolicy$package_2 : [])
  })];
  if (isK8s === 'IS_KUBERNETES_MULTIPAGE') {
    steps.push((0, _run_k8s_apply_command_step.KubernetesManifestApplyStep)({
      isComplete: applyCommandCopied || !!enrolledAgentIds.length,
      fullCopyButton: true,
      onCopy: () => setApplyCommandCopied(true)
    }));
  }
  steps.push((0, _steps.AgentEnrollmentConfirmationStep)({
    selectedPolicyId: agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id,
    troubleshootLink: link,
    agentCount: enrolledAgentIds.length,
    showLoading: true,
    poll: commandCopied
  }));
  if (!agentVersion) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addIntegration.installAgentStepTitle",
    defaultMessage: "These steps configure and enroll the Elastic Agent in Fleet to automatically deploy updates and centrally manage the agent. As an alternative to Fleet, advanced users can run agents in {standaloneLink}.",
    values: {
      standaloneLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => setIsManaged(false)
      }, "standalone mode")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xl'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps
  }), !!enrolledAgentIds.length && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.NotObscuredByBottomBar, null), /*#__PURE__*/_react.default.createElement(_.CreatePackagePolicyBottomBar, {
    cancelUrl: cancelUrl,
    cancelClickHandler: cancelClickHandler,
    onNext: onNext,
    actionMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.addFirstIntegrationSplash.addIntegrationButton",
      defaultMessage: "Add the integration"
    })
  })));
};
exports.InstallElasticAgentManagedPageStep = InstallElasticAgentManagedPageStep;