"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmIncomingDataStandalone = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmIncomingDataStandalone = ({
  troubleshootLink
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    color: "primary",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.confirmIncomingDataStandalone.title",
      defaultMessage: "Data preview is not available for standalone agents. "
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.confirmIncomingDataStandalone.description",
    defaultMessage: "You can check for agent data in the integration asset tab. If you're having trouble seeing data, check out the {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        external: true,
        href: troubleshootLink
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.confirmIncomingDataStandalone.troubleshootingLink",
        defaultMessage: "troubleshooting guide"
      }))
    }
  }))));
};
exports.ConfirmIncomingDataStandalone = ConfirmIncomingDataStandalone;