"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotObscuredByBottomBar = exports.CreatePackagePolicyFinalBottomBar = exports.CreatePackagePolicyBottomBar = exports.AgentStandaloneBottomBar = exports.AgentDataTimedOutBottomBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../../../hooks");
var _hooks2 = require("../hooks");
var _common = require("../../../../../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CenteredRoundedBottomBar = (0, _styledComponents.default)(_eui.EuiBottomBar)`
  max-width: 820px;
  margin: 0 auto !important; /* !important is needed for serverless */
  border-radius: 8px 8px 0px 0px;
`;
const NoAnimationCenteredRoundedBottomBar = (0, _styledComponents.default)(CenteredRoundedBottomBar)`
  animation-delay: -99s; #stop bottom bar flying in on step change
`;
const NotObscuredByBottomBar = exports.NotObscuredByBottomBar = (0, _styledComponents.default)('div')`
  padding-bottom: 100px;
`;
const CreatePackagePolicyBottomBar = ({
  isLoading,
  loadingMessage,
  onNext,
  cancelClickHandler,
  cancelUrl,
  actionMessage,
  cancelMessage,
  isDisabled = false,
  noAnimation = false
}) => {
  const Bar = noAnimation ? NoAnimationCenteredRoundedBottomBar : CenteredRoundedBottomBar;
  return /*#__PURE__*/_react.default.createElement(Bar, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    size: "s",
    href: cancelUrl,
    onClick: cancelClickHandler
  }, cancelMessage || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicyBottomBar.backButton",
    defaultMessage: "Go back"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    size: "m",
    isDisabled: isDisabled,
    isLoading: !isDisabled && isLoading,
    onClick: onNext
  }, isLoading ? loadingMessage || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicyBottomBar.loading",
    defaultMessage: "Loading..."
  }) : actionMessage))));
};
exports.CreatePackagePolicyBottomBar = CreatePackagePolicyBottomBar;
const AgentStandaloneBottomBar = ({
  onNext,
  cancelClickHandler,
  cancelUrl,
  noAnimation = false
}) => {
  const Bar = noAnimation ? NoAnimationCenteredRoundedBottomBar : CenteredRoundedBottomBar;
  return /*#__PURE__*/_react.default.createElement(Bar, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    size: "s",
    href: cancelUrl,
    onClick: cancelClickHandler
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentStandaloneBottomBar.backButton",
    defaultMessage: "Go back"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    size: "m",
    onClick: onNext
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentStandaloneBottomBar.viewIncomingDataBtn",
    defaultMessage: "View incoming data"
  })))));
};
exports.AgentStandaloneBottomBar = AgentStandaloneBottomBar;
const CreatePackagePolicyFinalBottomBar = ({
  pkgkey
}) => {
  const isK8s = pkgkey.includes(_common.FLEET_KUBERNETES_PACKAGE);
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    getAbsolutePath
  } = (0, _hooks.useLink)();
  return /*#__PURE__*/_react.default.createElement(CenteredRoundedBottomBar, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    size: "s",
    href: getHref('integrations_all')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicyBottomBar.addAnotherIntegration",
    defaultMessage: "Add another integration"
  })))), !isK8s && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    fill: true,
    size: "m",
    href: getHref('integration_details_assets', {
      pkgkey
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.confirmIncomingData.viewDataAssetsButtonText'",
    defaultMessage: "View assets"
  }))), isK8s && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    fill: true,
    size: "m",
    href: getAbsolutePath('/app/dashboards#/view/kubernetes-f4dc26db-1b53-4ea2-a78b-1bfab8ea267c')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.confirmIncomingData. '",
    defaultMessage: "View Kubernetes metrics dashboards"
  })))));
};
exports.CreatePackagePolicyFinalBottomBar = CreatePackagePolicyFinalBottomBar;
const AgentDataTimedOutBottomBar = ({
  troubleshootLink,
  agentIds,
  integration
}) => {
  const discoverLogsLink = (0, _hooks2.useGetDiscoverLogsLinkForAgents)(agentIds);
  return /*#__PURE__*/_react.default.createElement(CenteredRoundedBottomBar, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    size: "s",
    href: troubleshootLink,
    iconType: "popout",
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.confirmIncomingData.timeout.troubleshootLinkBottomBar",
    defaultMessage: "Troubleshooting guide"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    fill: true,
    href: discoverLogsLink !== null && discoverLogsLink !== void 0 ? discoverLogsLink : ''
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.confirmIncomingData.timeout.discoverLogsLink",
    defaultMessage: "View incoming {integration} logs",
    values: {
      integration: integration !== null && integration !== void 0 ? integration : ''
    }
  })))));
};
exports.AgentDataTimedOutBottomBar = AgentDataTimedOutBottomBar;