"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfirmFleetServerConnectionStep = getConfirmFleetServerConnectionStep;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getConfirmFleetServerConnectionStep({
  disabled,
  hasRecentlyEnrolledFleetServers
}) {
  return {
    title: hasRecentlyEnrolledFleetServers ? _i18n.i18n.translate('xpack.fleet.fleetServerFlyout.confirmConnectionSuccessTitle', {
      defaultMessage: 'Fleet Server connected'
    }) : _i18n.i18n.translate('xpack.fleet.fleetServerFlyout.confirmConnectionTitle', {
      defaultMessage: 'Confirm connection'
    }),
    status: hasRecentlyEnrolledFleetServers ? 'complete' : 'disabled',
    children: !disabled && /*#__PURE__*/_react.default.createElement(ConfirmFleetServerConnectionStepContent, {
      hasRecentlyEnrolledFleetServers: hasRecentlyEnrolledFleetServers
    })
  };
}
const ConfirmFleetServerConnectionStepContent = ({
  hasRecentlyEnrolledFleetServers
}) => {
  const flyoutContext = (0, _hooks.useFlyoutContext)();
  const fleetStatus = (0, _hooks.useFleetStatus)();
  const handleContinueClick = () => {
    fleetStatus.forceDisplayInstructions = false;
    flyoutContext.closeFleetServerFlyout();
    flyoutContext.openEnrollmentFlyout();
  };
  return hasRecentlyEnrolledFleetServers ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerFlyout.connectionSuccessful",
    defaultMessage: "You can now continue enrolling agents with Fleet."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: handleContinueClick,
    "data-test-subj": "fleetServerFlyoutContinueEnrollingButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerFlyout.continueEnrollingButton",
    defaultMessage: "Continue enrolling Elastic Agent"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  });
};