"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchEventAnnotations = fetchEventAnnotations;
exports.getFetchEventAnnotations = getFetchEventAnnotations;
var _fetch_event_annotations = require("../../common/fetch_event_annotations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function fetchEventAnnotations({
  getStartDependencies
}) {
  return {
    ...(0, _fetch_event_annotations.getFetchEventAnnotationsMeta)(),
    fn: (input, args, context) => {
      return (0, _fetch_event_annotations.requestEventAnnotations)(input, args, context, getStartDependencies);
    }
  };
}
function getFetchEventAnnotations({
  getStartServices
}) {
  return fetchEventAnnotations({
    getStartDependencies: async () => {
      const [{
        uiSettings
      }, {
        data: {
          search,
          dataViews,
          nowProvider
        }
      }] = await getStartServices();
      return {
        aggs: search.aggs,
        searchSource: search.searchSource,
        dataViews,
        getNow: () => nowProvider.get(),
        uiSettings
      };
    }
  });
}