"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractSemanticsFromGrok = extractSemanticsFromGrok;
exports.fieldsSuggestionsAfter = void 0;
var _esqlAst = require("@kbn/esql-ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function unquoteTemplate(inputString) {
  if (inputString.startsWith('"') && inputString.endsWith('"') && inputString.length >= 2) {
    return inputString.substring(1, inputString.length - 1);
  }
  return inputString;
}
function extractSemanticsFromGrok(pattern) {
  const regex = /%\{\w+:(?<column>[\w@]+)\}/g;
  const matches = pattern.matchAll(regex);
  const columns = [];
  for (const match of matches) {
    var _match$groups;
    if (match !== null && match !== void 0 && (_match$groups = match.groups) !== null && _match$groups !== void 0 && _match$groups.column) {
      columns.push(match.groups.column);
    }
  }
  return columns;
}
const fieldsSuggestionsAfter = (command, previousCommandFields, userDefinedColumns) => {
  const columns = [];
  (0, _esqlAst.walk)(command, {
    visitLiteral: node => {
      const grokRegex = unquoteTemplate(String(node.value));
      columns.push(...extractSemanticsFromGrok(grokRegex));
    }
  });
  return [...previousCommandFields, ...columns.map(column => ({
    name: column,
    type: 'keyword'
  }))];
};
exports.fieldsSuggestionsAfter = fieldsSuggestionsAfter;