"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseErrors = exports.parse = exports.createParser = exports.Parser = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _antlr = require("antlr4");
var _esql_error_listener = require("./esql_error_listener");
var _esql_ast_builder_listener = require("./esql_ast_builder_listener");
var _constants = require("./constants");
var _formatting = require("./formatting");
var _builder = require("../builder");
var _esql_lexer = _interopRequireDefault(require("../antlr/esql_lexer"));
var _esql_parser = _interopRequireDefault(require("../antlr/esql_parser"));
var _Parser;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class Parser {
  constructor(src, options = {}) {
    (0, _defineProperty2.default)(this, "streams", void 0);
    (0, _defineProperty2.default)(this, "lexer", void 0);
    (0, _defineProperty2.default)(this, "tokens", void 0);
    (0, _defineProperty2.default)(this, "parser", void 0);
    (0, _defineProperty2.default)(this, "errors", new _esql_error_listener.ESQLErrorListener());
    (0, _defineProperty2.default)(this, "listener", void 0);
    this.src = src;
    this.options = options;
    this.listener = new _esql_ast_builder_listener.ESQLAstBuilderListener(src);
    const streams = this.streams = _antlr.CharStreams.fromString(src);
    const lexer = this.lexer = new _esql_lexer.default(streams);
    const tokens = this.tokens = new _antlr.CommonTokenStream(lexer);
    const parser = this.parser = new _esql_parser.default(tokens);
    lexer.removeErrorListeners();
    lexer.addErrorListener(this.errors);
    parser.removeErrorListeners();
    parser.addErrorListener(this.errors);
    if (this.listener) {
      // The addParseListener API does exist and is documented here
      // https://github.com/antlr/antlr4/blob/dev/doc/listeners.md
      parser.addParseListener(this.listener);
    }
  }
  parse() {
    const {
      src,
      options
    } = this;
    try {
      this.parser[_constants.GRAMMAR_ROOT_RULE]();
      const errors = this.errors.getErrors();
      const {
        ast: commands
      } = this.listener.getAst();
      const root = _builder.Builder.expression.query(commands, {
        location: {
          min: 0,
          max: src.length - 1
        }
      });
      if (options.withFormatting) {
        const decorations = (0, _formatting.collectDecorations)(this.tokens);
        (0, _formatting.attachDecorations)(root, this.tokens.tokens, decorations.lines);
      }
      return {
        root,
        ast: commands,
        errors,
        tokens: this.tokens.tokens
      };
    } catch (error) {
      if (error !== 'Empty Stack')
        // eslint-disable-next-line no-console
        console.error(error);
      const root = _builder.Builder.expression.query();
      return {
        root,
        ast: root.commands,
        errors: [{
          startLineNumber: 0,
          endLineNumber: 0,
          startColumn: 0,
          endColumn: 0,
          message: `Invalid query [${src}]`,
          severity: 'error'
        }],
        tokens: []
      };
    }
  }
  parseErrors() {
    this.parser[_constants.GRAMMAR_ROOT_RULE]();
    return this.errors.getErrors();
  }
}

/**
 * @deprecated Use `Parser.create` instead.
 */
exports.Parser = Parser;
_Parser = Parser;
(0, _defineProperty2.default)(Parser, "create", (src, options) => {
  return new _Parser(src, options);
});
(0, _defineProperty2.default)(Parser, "parse", (src, options) => {
  return _Parser.create(src, options).parse();
});
(0, _defineProperty2.default)(Parser, "parseErrors", src => {
  return _Parser.create(src).parseErrors();
});
const createParser = exports.createParser = Parser.create;

/**
 * @deprecated Use `Parser.parseErrors` instead.
 */
const parseErrors = exports.parseErrors = Parser.parseErrors;

/**
 * @deprecated Use `Parser.parse` instead.
 */
const parse = (src, options = {}) => {
  if (src == null) {
    const commands = [];
    return {
      ast: commands,
      root: _builder.Builder.expression.query(commands),
      errors: [],
      tokens: []
    };
  }
  return Parser.create(src, options).parse();
};
exports.parse = parse;