"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createJoinCommand = void 0;
var _factories = require("../factories");
var _walkers = require("../walkers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createNodeFromJoinTarget = ctx => {
  return (0, _factories.visitSource)(ctx._index);
};
const createJoinCommand = ctx => {
  var _ctx$_type_$text, _ctx$_type_;
  const command = (0, _factories.createCommand)('join', ctx);

  // Pick-up the <TYPE> of the command.
  command.commandType = ((_ctx$_type_$text = (_ctx$_type_ = ctx._type_) === null || _ctx$_type_ === void 0 ? void 0 : _ctx$_type_.text) !== null && _ctx$_type_$text !== void 0 ? _ctx$_type_$text : 'lookup').toLocaleLowerCase();
  const joinTarget = createNodeFromJoinTarget(ctx.joinTarget());
  const joinCondition = ctx.joinCondition();
  const onOption = (0, _factories.createOption)('on', joinCondition);
  const joinPredicates = onOption.args;
  for (const joinPredicateCtx of joinCondition.joinPredicate_list()) {
    const expression = (0, _walkers.visitValueExpression)(joinPredicateCtx.valueExpression());
    if (expression) {
      joinPredicates.push(expression);
    }
  }
  command.args.push(joinTarget);
  if (onOption.args.length) {
    command.args.push(onOption);
  }
  return command;
};
exports.createJoinCommand = createJoinCommand;