"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEnrichCommand = void 0;
var _builder = require("../../builder");
var _factories = require("../factories");
var _walkers = require("../walkers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const visitPolicyName = ctx => {
  const policyName = ctx._policyName;
  if (!policyName || !(0, _factories.textExistsAndIsValid)(policyName.text)) {
    const source = _builder.Builder.expression.source.node({
      sourceType: 'policy',
      name: '',
      index: '',
      prefix: ''
    }, {
      incomplete: true,
      text: '',
      location: {
        min: policyName.start,
        max: policyName.stop
      }
    });
    return source;
  }
  const name = ctx._policyName.text;
  const colonIndex = name.indexOf(':');
  const withPrefix = colonIndex !== -1;
  const incomplete = false;
  let index;
  let prefix;
  if (withPrefix) {
    const prefixName = name.substring(0, colonIndex);
    const indexName = name.substring(colonIndex + 1);
    prefix = _builder.Builder.expression.literal.string(prefixName, {
      unquoted: true
    }, {
      text: prefixName,
      incomplete: false,
      location: {
        min: policyName.start,
        max: policyName.start + prefixName.length - 1
      }
    });
    index = _builder.Builder.expression.literal.string(indexName, {
      unquoted: true
    }, {
      text: indexName,
      incomplete: false,
      location: {
        min: policyName.start + prefixName.length + 1,
        max: policyName.stop
      }
    });
  } else {
    index = _builder.Builder.expression.literal.string(name, {
      unquoted: true
    }, {
      text: name,
      incomplete: false,
      location: {
        min: policyName.start,
        max: policyName.stop
      }
    });
  }
  const source = _builder.Builder.expression.source.node({
    sourceType: 'policy',
    name,
    index,
    prefix
  }, {
    incomplete,
    text: name,
    location: {
      min: policyName.start,
      max: policyName.stop
    }
  });
  return source;
};
const createEnrichCommand = ctx => {
  const command = (0, _factories.createCommand)('enrich', ctx);
  const policy = visitPolicyName(ctx);
  command.args.push(policy);
  if (policy.incomplete) {
    command.incomplete = true;
  }
  command.args.push(...(0, _walkers.getMatchField)(ctx), ...(0, _walkers.getEnrichClauses)(ctx));
  return command;
};
exports.createEnrichCommand = createEnrichCommand;