"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
require("./data_panel.scss");
var _loading = require("../loading");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataPanel = ({
  title,
  titleSize = 'xs',
  subtitle,
  iconType,
  action,
  filled,
  isLoading,
  footerDocLink,
  className,
  children,
  ...props // e.g., data-test-subj
}) => {
  const classes = (0, _classnames.default)('dataPanel', className, {
    'dataPanel--filled': filled
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, (0, _extends2.default)({
    color: filled ? 'subdued' : 'plain',
    className: classes,
    hasShadow: false,
    hasBorder: !filled,
    "aria-busy": isLoading
  }, props), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "eui-textNoWrap",
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, iconType && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: titleSize
  }, title)))), action && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, action)), subtitle && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, subtitle))), children && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: filled || subtitle ? 'l' : 's'
  }), children), isLoading && /*#__PURE__*/_react.default.createElement(_loading.LoadingOverlay, null)), !!footerDocLink && /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued"
  }, footerDocLink));
};
exports.DataPanel = DataPanel;