"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorViewIndexLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../shared/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorViewIndexLink = ({
  indexName,
  target
}) => {
  var _share$url$locators$g;
  const {
    share
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const searchIndexDetailsUrl = share === null || share === void 0 ? void 0 : (_share$url$locators$g = share.url.locators.get('SEARCH_INDEX_DETAILS_LOCATOR_ID')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({
    indexName
  });
  return searchIndexDetailsUrl ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: target ? '_blank' : undefined,
    external: target !== null && target !== void 0 ? target : false,
    href: searchIndexDetailsUrl
  }, indexName) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indexName);
};
exports.ConnectorViewIndexLink = ConnectorViewIndexLink;