"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _pipeline_select_logic = require("./pipeline_select_logic");
var _pipeline_select_option = require("./pipeline_select_option");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineSelect = () => {
  const {
    addInferencePipelineModal: {
      configuration: {
        pipelineName
      }
    },
    existingInferencePipelines
  } = (0, _kea.useValues)(_pipeline_select_logic.PipelineSelectLogic);
  const {
    selectExistingPipeline
  } = (0, _kea.useActions)(_pipeline_select_logic.PipelineSelectLogic);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const largeScreenRowHeight = euiTheme.base * 6;
  const smallScreenRowHeight = euiTheme.base * 8;
  const maxVisibleOptions = 4.5;
  const rowHeight = (0, _eui.useIsWithinMaxBreakpoint)('s') ? smallScreenRowHeight : largeScreenRowHeight;
  const [height, setHeight] = (0, _react.useState)(maxVisibleOptions * rowHeight);
  const getPipelineOptions = pipelineOptions => {
    return pipelineOptions.map(pipelineOption => ({
      checked: pipelineOption.pipelineName === pipelineName ? 'on' : undefined,
      disabled: pipelineOption.disabled,
      label: pipelineOption.pipelineName,
      pipeline: pipelineOption
    }));
  };
  const renderPipelineOption = option => {
    return /*#__PURE__*/_react.default.createElement(_pipeline_select_option.PipelineSelectOption, option);
  };
  const onChange = options => {
    const selectedOption = options.find(option => option.checked === 'on');
    if (selectedOption) {
      selectExistingPipeline(selectedOption.pipeline.pipelineName);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: getPipelineOptions(existingInferencePipelines),
    listProps: {
      bordered: true,
      showIcons: true,
      onFocusBadge: false,
      rowHeight
    },
    searchProps: {
      onChange: (_, matchingOptions) => {
        setHeight(Math.min(maxVisibleOptions, matchingOptions.length) * rowHeight);
      }
    },
    searchable: true,
    singleSelection: "always",
    onChange: onChange,
    renderOption: renderPipelineOption,
    height: height
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list));
};
exports.PipelineSelect = PipelineSelect;