"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelSelectLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../../../common/types/api");
var _handle_api_errors = require("../../../../../shared/flash_messages/handle_api_errors");
var _create_model_api_logic = require("../../../../api/ml_models/create_model_api_logic");
var _start_model_api_logic = require("../../../../api/ml_models/start_model_api_logic");
var _index_view_logic = require("../../index_view_logic");
var _ml_inference_logic = require("./ml_inference_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ModelSelectLogic = exports.ModelSelectLogic = (0, _kea.kea)({
  actions: {
    createModel: modelId => ({
      modelId
    }),
    startModel: modelId => ({
      modelId
    })
  },
  connect: {
    actions: [_create_model_api_logic.CreateModelApiLogic, ['makeRequest as createModelMakeRequest', 'apiSuccess as createModelSuccess', 'apiError as createModelError'], _ml_inference_logic.MLInferenceLogic, ['clearModelPlaceholderFlag', 'setInferencePipelineConfiguration', 'startPollingModels'], _start_model_api_logic.StartModelApiLogic, ['makeRequest as startModelMakeRequest', 'apiSuccess as startModelSuccess', 'apiError as startModelError']],
    values: [_create_model_api_logic.CreateModelApiLogic, ['status as createModelStatus', 'error as createModelError'], _index_view_logic.IndexViewLogic, ['ingestionMethod'], _ml_inference_logic.MLInferenceLogic, ['addInferencePipelineModal', 'isModelsInitialLoading as isLoading', 'selectableModels', 'selectedModel'], _start_model_api_logic.StartModelApiLogic, ['status as startModelStatus', 'error as startModelError']]
  },
  listeners: ({
    actions
  }) => ({
    createModel: ({
      modelId
    }) => {
      actions.createModelMakeRequest({
        modelId
      });
    },
    createModelSuccess: response => {
      actions.startPollingModels();
      // The create action succeeded, so the model is no longer a placeholder
      actions.clearModelPlaceholderFlag(response.modelId);
    },
    startModel: ({
      modelId
    }) => {
      actions.startModelMakeRequest({
        modelId
      });
    },
    startModelSuccess: () => {
      actions.startPollingModels();
    }
  }),
  path: ['enterprise_search', 'content', 'model_select_logic'],
  selectors: ({
    selectors
  }) => ({
    areActionButtonsDisabled: [() => [selectors.createModelStatus, selectors.startModelStatus], (createModelStatus, startModelStatus) => createModelStatus === _api.Status.LOADING || startModelStatus === _api.Status.LOADING],
    modelStateChangeError: [() => [selectors.createModelError, selectors.startModelError], (createModelError, startModelError) => {
      if (!createModelError && !startModelError) return undefined;
      return (0, _handle_api_errors.getErrorsFromHttpResponse)(createModelError !== null && createModelError !== void 0 ? createModelError : startModelError)[0];
    }]
  })
});