"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomPipelineItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomPipelineItem = ({
  indexName,
  ingestionMethod,
  pipelineSuffix,
  processorsCount
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, `${indexName}@${pipelineSuffix}`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-customPipeline-editPipeline`,
    to: `/app/management/ingest/ingest_pipelines/?pipeline=${indexName}@${pipelineSuffix}`,
    shouldNotCreateHref: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestPipelinesCard.customButtonLabel', {
    defaultMessage: 'Edit pipeline'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    grow: false
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestPipelinesCard.customDescription', {
    defaultMessage: 'Custom ingest pipeline for {indexName}',
    values: {
      indexName
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestPipelinesCard.processorsDescription', {
    defaultMessage: '{processorsCount} Processors',
    values: {
      processorsCount
    }
  })))))));
};
exports.CustomPipelineItem = CustomPipelineItem;