"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorNameAndDescription = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../shared/constants");
var _indices = require("../../../../utils/indices");
var _index_view_logic = require("../../index_view_logic");
var _connector_name_and_description_form = require("./connector_name_and_description_form");
var _connector_name_and_description_logic = require("./connector_name_and_description_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorNameAndDescription = () => {
  const {
    index
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    isEditing,
    nameAndDescription: {
      name,
      description
    }
  } = (0, _kea.useValues)(_connector_name_and_description_logic.ConnectorNameAndDescriptionLogic);
  const {
    setIsEditing
  } = (0, _kea.useActions)(_connector_name_and_description_logic.ConnectorNameAndDescriptionLogic);
  if (!(0, _indices.isConnectorIndex)(index)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nameAndDescriptionForm.description', {
    defaultMessage: 'By naming and describing this connector your colleagues and wider team will know what this connector is meant for.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isEditing ? /*#__PURE__*/_react.default.createElement(_connector_name_and_description_form.ConnectorNameAndDescriptionForm, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      description: name !== null && name !== void 0 ? name : '--',
      title: _constants.NAME_LABEL
    }, {
      description: description || '--',
      title: _constants.DESCRIPTION_LABEL
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setIsEditing(!isEditing)
  }, _constants.EDIT_BUTTON_LABEL))))));
};
exports.ConnectorNameAndDescription = ConnectorNameAndDescription;