"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateEngineMenuItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../../common/constants");
var _routes = require("../../../../../applications/routes");
var _constants2 = require("../../../../../shared/constants");
var _encode_path_params = require("../../../../../shared/encode_path_params");
var _kibana = require("../../../../../shared/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateEngineMenuItem = ({
  indexName,
  ingestionMethod,
  isHiddenIndex
}) => {
  const searchApplicationCreationPath = !indexName ? `${_constants.APPLICATIONS_PLUGIN.URL}${_routes.SEARCH_APPLICATION_CREATION_PATH}` : (0, _encode_path_params.generateEncodedPath)(`${_constants.APPLICATIONS_PLUGIN.URL}${_routes.SEARCH_APPLICATION_CREATION_PATH}?:indexKey=:indexName`, {
    indexKey: _constants2.ESINDEX_QUERY_PARAMETER,
    indexName
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-header-createEngine-createEngine`,
    size: "s",
    icon: "plusInCircle",
    onClick: () => {
      _kibana.KibanaLogic.values.navigateToUrl(searchApplicationCreationPath, {
        shouldNotCreateHref: true
      });
    },
    disabled: isHiddenIndex
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.searchApplication.createSearchApplication', {
    defaultMessage: 'Create a Search Application'
  }))))));
};
exports.CreateEngineMenuItem = CreateEngineMenuItem;