"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _cached_fetch_index_api_logic = require("../../api/index/cached_fetch_index_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewLogic = exports.OverviewLogic = (0, _kea.kea)({
  connect: {
    values: [_cached_fetch_index_api_logic.CachedFetchIndexApiLogic, ['indexData', 'status']]
  },
  path: ['enterprise_search', 'connector_detail', 'overview'],
  selectors: ({
    selectors
  }) => ({
    isError: [() => [selectors.status], status => status === _api.Status.ERROR]
  })
});