"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RunOptionsButtons = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RunOptionsButtons = ({
  selectDeploymentMethod,
  selectedDeploymentMethod
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.description",
    defaultMessage: "The connector service is a Python package that you host on your own infrastructure. You can deploy with Docker or, optionally, run from source."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    onChange: () => selectDeploymentMethod('docker'),
    id: "xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.runConnectorService.docker",
    checked: selectedDeploymentMethod === 'docker',
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.connectorConfiguration.dockerTextLabel.ariaLabel', {
      defaultMessage: 'Run with Docker'
    }),
    name: "deployment-method-run-connector",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoDocker",
      size: "l"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorConfiguration.dockerTextLabel', {
      defaultMessage: 'Run with Docker'
    }))))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    onChange: () => selectDeploymentMethod('source'),
    id: "xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.runConnectorService.source",
    checked: selectedDeploymentMethod === 'source',
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.connectorConfiguration.sourceTextLabel.ariaLabel', {
      defaultMessage: 'Run from source'
    }),
    name: "deployment-method-run-connector",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoGithub",
      size: "l"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorConfiguration.sourceTextLabel', {
      defaultMessage: 'Run from source'
    }))))
  })))));
};
exports.RunOptionsButtons = RunOptionsButtons;