"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsOverviewEmptyPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _no_ml_models_dark = _interopRequireDefault(require("../../../../assets/images/no_ml_models_dark.svg"));
var _doc_links = require("../../../shared/doc_links");
var _add_analytics_collection = require("../add_analytics_collections/add_analytics_collection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ICON_WIDTH = 294;
const AnalyticsOverviewEmptyPage = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: ICON_WIDTH,
    src: _no_ml_models_dark.default,
    alt: "icon"
  }),
  layout: "horizontal",
  color: "plain",
  title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.emptyState.headingTitle', {
    defaultMessage: 'Create your first Collection'
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.emptyState.subHeading', {
    defaultMessage: 'Collections are required to store analytics events for your search application.'
  })),
  actions: [/*#__PURE__*/_react.default.createElement(_add_analytics_collection.AddAnalyticsCollection, null)],
  footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.emptyState.footerText', {
    defaultMessage: 'Want to learn more?'
  }))), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.behavioralAnalytics,
    target: "_blank",
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.emptyState.footerLink', {
    defaultMessage: 'Read documentation'
  })))
});
exports.AnalyticsOverviewEmptyPage = AnalyticsOverviewEmptyPage;