"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionExplorer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _page_template = require("../../layout/page_template");
var _analytics_collection_explore_table_logic = require("../analytics_collection_explore_table_logic");
var _analytics_collection_toolbar = require("../analytics_collection_toolbar/analytics_collection_toolbar");
var _fetch_analytics_collection_logic = require("../fetch_analytics_collection_logic");
var _analytics_collection_explorer_table = require("./analytics_collection_explorer_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsCollectionExplorer = ({}) => {
  const {
    analyticsCollection
  } = (0, _kea.useValues)(_fetch_analytics_collection_logic.FetchAnalyticsCollectionLogic);
  const {
    reset
  } = (0, _kea.useActions)(_analytics_collection_explore_table_logic.AnalyticsCollectionExploreTableLogic);
  (0, _react.useEffect)(() => {
    return () => {
      reset();
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchAnalyticsPageTemplate, {
    restrictWidth: true,
    pageChrome: [analyticsCollection === null || analyticsCollection === void 0 ? void 0 : analyticsCollection.name],
    analyticsName: analyticsCollection === null || analyticsCollection === void 0 ? void 0 : analyticsCollection.name,
    pageViewTelemetry: `View Analytics Collection - explorer`,
    pageHeader: {
      bottomBorder: false,
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.explorerView.title', {
        defaultMessage: 'Explorer'
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.deprecatedBadge', {
        defaultMessage: 'Deprecated'
      })))),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_analytics_collection_toolbar.AnalyticsCollectionToolbar, null)]
    }
  }, /*#__PURE__*/_react.default.createElement(_analytics_collection_explorer_table.AnalyticsCollectionExplorerTable, null));
};
exports.AnalyticsCollectionExplorer = AnalyticsCollectionExplorer;