"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NlpEnrichmentPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _routes = require("../../../enterprise_search_content/routes");
var _doc_links = require("../../../shared/doc_links");
var _react_router_helpers = require("../../../shared/react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const steps = [{
  title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.nlpEnrichmentPanel.step1.title', {
    defaultMessage: 'Learn how to upload ML models'
  }),
  children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-telemetry-id": "entSearch-aiSearch-semanticSearch-nlpEnrichmentPanel-supportedNlpModelsLink",
    href: _doc_links.docLinks.supportedNlpModels,
    target: "_blank",
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.nlpEnrichmentPanel.step1.supportedNlpModelsLinkText', {
    defaultMessage: 'Supported NLP models'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-telemetry-id": "entSearch-aiSearch-semanticSearch-nlpEnrichmentPanel-trainedModelsLink",
    href: _doc_links.docLinks.trainedModels,
    target: "_blank",
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.nlpEnrichmentPanel.step1.guideToTrainedModelsLinkText', {
    defaultMessage: 'Guide to trained models'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    "data-telemetry-id": "entSearch-aiSearch-semanticSearch-nlpEnrichmentPanel-trainedModelsButton",
    to: (0, _reactRouterDom.generatePath)(_routes.ML_MANAGE_TRAINED_MODELS_PATH),
    shouldNotCreateHref: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "eye"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.nlpEnrichmentPanel.step1.buttonLabel', {
    defaultMessage: 'View trained models'
  }))))),
  status: 'incomplete'
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.nlpEnrichmentPanel.step2.title', {
    defaultMessage: 'Create an index'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    "data-telemetry-id": "entSearch-aiSearch-semanticSearch-nlpEnrichmentPanel-createIndexButton",
    to: (0, _reactRouterDom.generatePath)('/app/elasticsearch/indices/create'),
    shouldNotCreateHref: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.nlpEnrichmentPanel.step2.buttonLabel', {
    defaultMessage: 'Create an index'
  }))),
  status: 'incomplete'
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.nlpEnrichmentPanel.step3.title', {
    defaultMessage: 'Create an ML inference pipeline'
  }),
  children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.aiSearch.nlpEnrichmentPanel.step3.description",
    defaultMessage: "Navigate to your index's {pipelinesName} tab to create an inference pipeline that uses your deployed model.",
    values: {
      pipelinesName: /*#__PURE__*/_react.default.createElement("strong", null, "\"", _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.nlpEnrichmentPanel.step3.description.pipelinesName', {
        defaultMessage: 'Pipelines'
      }), "\"")
    }
  }))),
  status: 'incomplete'
}];
const NlpEnrichmentPanel = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.aiSearch.nlpEnrichmentPanel.description",
  defaultMessage: "Use Natural Language Processing (NLP) tools like sentiment analysis, summarization, or Named Entity Recognition to enhance the relevance of your search results. NLP uses several {supportedMlModels} you can load to intelligently analyze and enrich documents with additional fields.",
  values: {
    supportedMlModels: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-telemetry-id": "entSearch-aiSearch-semanticSearch-nlpEnrichmentPanel-supportedMlModelsLink",
      target: "_blank",
      href: _doc_links.docLinks.supportedNlpModels,
      external: false
    }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.nlpEnrichmentPanel.description.supportedMlModelsLinkText', {
      defaultMessage: 'supported ML models'
    }))
  }
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
  steps: steps,
  titleSize: "xs"
}))));
exports.NlpEnrichmentPanel = NlpEnrichmentPanel;