"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRawDataOrDefault = void 0;
var _is_raw_data_valid = require("../is_raw_data_valid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Returns the raw data if it valid, or a default if it's not */
const getRawDataOrDefault = rawData => (0, _is_raw_data_valid.isRawDataValid)(rawData) ? rawData : {};
exports.getRawDataOrDefault = getRawDataOrDefault;