"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverMainApp = DiscoverMainApp;
var _react = _interopRequireWildcard(require("react"));
var _domDragDrop = require("@kbn/dom-drag-drop");
var _layout = require("../layout");
var _breadcrumbs = require("../../../../utils/breadcrumbs");
var _help_menu_util = require("../../../../components/help_menu/help_menu_util");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _saved_search_alias_match_redirect = require("../../../../hooks/saved_search_alias_match_redirect");
var _discover_state_provider = require("../../state_management/discover_state_provider");
var _use_adhoc_data_views = require("../../hooks/use_adhoc_data_views");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DiscoverLayoutMemoized = /*#__PURE__*/_react.default.memo(_layout.DiscoverLayout);
function DiscoverMainApp({
  stateContainer
}) {
  const savedSearch = (0, _discover_state_provider.useSavedSearchInitial)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    chrome,
    docLinks,
    data,
    spaces,
    history
  } = services;

  /**
   * Adhoc data views functionality
   */
  (0, _use_adhoc_data_views.useAdHocDataViews)();

  /**
   * SavedSearch dependent initializing
   */
  (0, _react.useEffect)(() => {
    // TODO: This can be moved to Discover session initialization, some of the logic is already duplicated
    if (stateContainer.customizationContext.displayMode === 'standalone') {
      const pageTitleSuffix = savedSearch.id && savedSearch.title ? `: ${savedSearch.title}` : '';
      chrome.docTitle.change(`Discover${pageTitleSuffix}`);
      (0, _breadcrumbs.setBreadcrumbs)({
        titleBreadcrumbText: savedSearch.title,
        services
      });
    }
  }, [chrome.docTitle, savedSearch.id, savedSearch.title, services, stateContainer.customizationContext.displayMode]);

  // TODO: Move this higher up in the component tree
  (0, _react.useEffect)(() => {
    (0, _help_menu_util.addHelpMenuToAppChrome)(chrome, docLinks);
  }, [chrome, docLinks]);
  (0, _react.useEffect)(() => {
    return () => {
      // clear session when navigating away from discover main
      data.search.session.clear();
    };
  }, [data.search.session]);

  // TODO: Move this higher up in the component tree
  (0, _saved_search_alias_match_redirect.useSavedSearchAliasMatchRedirect)({
    savedSearch,
    spaces,
    history
  });
  return /*#__PURE__*/_react.default.createElement(_domDragDrop.RootDragDropProvider, null, /*#__PURE__*/_react.default.createElement(DiscoverLayoutMemoized, {
    stateContainer: stateContainer
  }));
}