"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DevToolsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _deeplinksDevtools = require("@kbn/deeplinks-devtools");
var _dev_tool = require("./dev_tool");
var _services = require("./services");
require("./index.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class DevToolsPlugin {
  getSortedDevTools() {
    return (0, _lodash.sortBy)([...this.devTools.values()], 'order');
  }
  constructor() {
    (0, _defineProperty2.default)(this, "devTools", new Map());
    (0, _defineProperty2.default)(this, "appStateUpdater", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "breadcrumbService", new _services.BreadcrumbService());
    (0, _defineProperty2.default)(this, "docTitleService", new _services.DocTitleService());
  }
  setup(coreSetup, {
    urlForwarding
  }) {
    const {
      application: applicationSetup,
      getStartServices
    } = coreSetup;
    applicationSetup.register({
      id: 'dev_tools',
      title: _i18n.i18n.translate('devTools.devToolsTitle', {
        defaultMessage: 'Dev Tools'
      }),
      updater$: this.appStateUpdater,
      euiIconType: 'logoElastic',
      order: 9010,
      category: _public.DEFAULT_APP_CATEGORIES.management,
      mount: async params => {
        const {
          element,
          history
        } = params;
        element.classList.add('devAppWrapper');
        const [core] = await getStartServices();
        const {
          application,
          chrome,
          executionContext
        } = core;
        const {
          analytics,
          i18n: i18nStart,
          theme,
          userProfile
        } = core;
        const startServices = {
          analytics,
          i18n: i18nStart,
          theme,
          userProfile
        };
        this.docTitleService.setup(chrome.docTitle.change);
        this.breadcrumbService.setup(chrome.setBreadcrumbs);
        const appServices = {
          breadcrumbService: this.breadcrumbService,
          docTitleService: this.docTitleService,
          executionContext
        };
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        return renderApp(element, application, chrome, history, this.getSortedDevTools(), appServices, startServices);
      }
    });
    urlForwarding.forwardApp('dev_tools', 'dev_tools');
    return {
      register: devToolArgs => {
        if (this.devTools.has(devToolArgs.id)) {
          throw new Error(`Dev tool with id [${devToolArgs.id}] has already been registered. Use a unique id.`);
        }
        const devTool = (0, _dev_tool.createDevToolApp)(devToolArgs);
        this.devTools.set(devTool.id, devTool);
        return devTool;
      }
    };
  }
  start() {
    if (this.getSortedDevTools().length === 0) {
      this.appStateUpdater.next(() => ({
        status: _public.AppStatus.inaccessible
      }));
    } else {
      this.appStateUpdater.next(() => {
        const deepLinks = [...this.devTools.values()].filter(
        // Some tools do not use a string title, so we filter those out
        tool => !tool.isDisabled() && typeof tool.title === 'string').map(tool => {
          const deepLink = {
            id: tool.id,
            title: tool.title,
            path: `#/${tool.id}`
          };
          if (!_deeplinksDevtools.deepLinkIds.some(id => id === deepLink.id)) {
            throw new Error('Deeplink must be registered in package.');
          }
          return deepLink;
        });
        return {
          deepLinks
        };
      });
    }
  }
  stop() {}
}
exports.DevToolsPlugin = DevToolsPlugin;