"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatusFilter = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _ = require("..");
var _status = require("../status");
var _status2 = require("../../../../../../common/search/session/status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getStatusFilter = tableData => ({
  type: 'field_value_selection',
  name: _i18n.i18n.translate('data.mgmt.searchSessions.search.filterStatus', {
    defaultMessage: 'Status'
  }),
  field: 'status',
  multiSelect: 'or',
  options: Object.values(_status2.SearchSessionStatus).sort().map(status => ({
    value: status,
    view: /*#__PURE__*/_react.default.createElement(_.TableText, null, (0, _status.getStatusText)(status))
  }))
});
exports.getStatusFilter = getStatusFilter;