"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resetConfirmStrings = exports.noItemsStrings = exports.getNewDashboardTitle = exports.dashboardUnsavedListingStrings = exports.dashboardListingTableStrings = exports.dashboardListingErrorStrings = exports.createConfirmStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const dashboardListingErrorStrings = exports.dashboardListingErrorStrings = {
  getErrorDeletingDashboardToast: () => _i18n.i18n.translate('dashboard.deleteError.toastDescription', {
    defaultMessage: 'Error encountered while deleting dashboard'
  }),
  getDuplicateTitleWarning: value => _i18n.i18n.translate('dashboard.dashboardListingEditErrorTitle.duplicateWarning', {
    defaultMessage: 'Saving "{value}" creates a duplicate title',
    values: {
      value
    }
  })
};
const getNewDashboardTitle = () => _i18n.i18n.translate('dashboard.listing.newDashboardTitle', {
  defaultMessage: 'New Dashboard'
});
exports.getNewDashboardTitle = getNewDashboardTitle;
const dashboardListingTableStrings = exports.dashboardListingTableStrings = {
  getEntityName: () => _i18n.i18n.translate('dashboard.listing.table.entityName', {
    defaultMessage: 'dashboard'
  }),
  getEntityNamePlural: () => _i18n.i18n.translate('dashboard.listing.table.entityNamePlural', {
    defaultMessage: 'dashboards'
  }),
  getTableListTitle: () => _i18n.i18n.translate('dashboard.listing.tableListTitle', {
    defaultMessage: 'Dashboards'
  })
};
const noItemsStrings = exports.noItemsStrings = {
  getReadonlyTitle: () => _i18n.i18n.translate('dashboard.listing.readonlyNoItemsTitle', {
    defaultMessage: 'No dashboards to view'
  }),
  getReadonlyBody: () => _i18n.i18n.translate('dashboard.listing.readonlyNoItemsBody', {
    defaultMessage: `There are no available dashboards. To change your permissions to view the dashboards in this space, contact your administrator.`
  }),
  getReadEditTitle: () => _i18n.i18n.translate('dashboard.listing.createNewDashboard.title', {
    defaultMessage: 'Create your first dashboard'
  }),
  getReadEditInProgressTitle: () => _i18n.i18n.translate('dashboard.listing.createNewDashboard.inProgressTitle', {
    defaultMessage: 'Dashboard in progress'
  }),
  getReadEditDashboardDescription: () => _i18n.i18n.translate('dashboard.listing.createNewDashboard.combineDataViewFromKibanaAppDescription', {
    defaultMessage: 'Analyze all of your Elastic data in one place by creating a dashboard and adding visualizations.'
  }),
  getSampleDataLinkText: () => _i18n.i18n.translate('dashboard.listing.createNewDashboard.sampleDataInstallLinkText', {
    defaultMessage: `Add some sample data`
  }),
  getCreateNewDashboardText: () => _i18n.i18n.translate('dashboard.listing.createNewDashboard.createButtonLabel', {
    defaultMessage: `Create a dashboard`
  })
};
const dashboardUnsavedListingStrings = exports.dashboardUnsavedListingStrings = {
  getUnsavedChangesTitle: (plural = false) => _i18n.i18n.translate('dashboard.listing.unsaved.unsavedChangesTitle', {
    defaultMessage: 'You have unsaved changes in the following {dash}:',
    values: {
      dash: plural ? dashboardListingTableStrings.getEntityNamePlural() : dashboardListingTableStrings.getEntityName()
    }
  }),
  getLoadingTitle: () => _i18n.i18n.translate('dashboard.listing.unsaved.loading', {
    defaultMessage: 'Loading'
  }),
  getEditAriaLabel: title => _i18n.i18n.translate('dashboard.listing.unsaved.editAria', {
    defaultMessage: 'Continue editing {title}',
    values: {
      title
    }
  }),
  getEditTitle: () => _i18n.i18n.translate('dashboard.listing.unsaved.editTitle', {
    defaultMessage: 'Continue editing'
  }),
  getDiscardAriaLabel: title => _i18n.i18n.translate('dashboard.listing.unsaved.resetAria', {
    defaultMessage: 'Reset changes to {title}',
    values: {
      title
    }
  }),
  getDiscardTitle: () => _i18n.i18n.translate('dashboard.listing.unsaved.resetTitle', {
    defaultMessage: 'Reset changes'
  })
};
const resetConfirmStrings = exports.resetConfirmStrings = {
  getResetTitle: () => _i18n.i18n.translate('dashboard.resetChangesConfirmModal.resetChangesTitle', {
    defaultMessage: 'Reset dashboard?'
  }),
  getResetSubtitle: viewMode => viewMode === 'edit' ? _i18n.i18n.translate('dashboard.discardChangesConfirmModal.discardChangesDescription', {
    defaultMessage: `All unsaved changes will be lost.`
  }) : _i18n.i18n.translate('dashboard.resetChangesConfirmModal.resetChangesDescription', {
    defaultMessage: `This dashboard will return to its last saved state.  You might lose changes to filters and queries.`
  }),
  getResetConfirmButtonText: () => _i18n.i18n.translate('dashboard.resetChangesConfirmModal.confirmButtonLabel', {
    defaultMessage: 'Reset dashboard'
  })
};
const createConfirmStrings = exports.createConfirmStrings = {
  getCreateTitle: () => _i18n.i18n.translate('dashboard.createConfirmModal.unsavedChangesTitle', {
    defaultMessage: 'New dashboard already in progress'
  }),
  getCreateSubtitle: () => _i18n.i18n.translate('dashboard.createConfirmModal.unsavedChangesSubtitle', {
    defaultMessage: 'Continue editing or start over with a blank dashboard.'
  }),
  getStartOverButtonText: () => _i18n.i18n.translate('dashboard.createConfirmModal.confirmButtonLabel', {
    defaultMessage: 'Start over'
  }),
  getContinueButtonText: () => _i18n.i18n.translate('dashboard.createConfirmModal.continueButtonLabel', {
    defaultMessage: 'Continue editing'
  }),
  getCancelButtonText: () => _i18n.i18n.translate('dashboard.createConfirmModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  })
};