"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPanelTo = exports.EuiListGroupItemTo = exports.EuiLinkTo = exports.EuiCardTo = exports.EuiButtonTo = exports.EuiButtonIconTo = exports.EuiButtonEmptyTo = exports.EuiBadgeTo = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Correctly typed component helpers with React-Router-friendly `href` and `onClick` props
 */

const EuiLinkTo = ({
  to,
  onClick,
  shouldNotCreateHref,
  ...rest
}) => {
  var _services$application;
  const {
    services
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, rest, (0, _.generateReactRouterProps)({
    to,
    onClick,
    shouldNotCreateHref,
    http: services.http,
    navigateToUrl: (_services$application = services.application) === null || _services$application === void 0 ? void 0 : _services$application.navigateToUrl,
    history: history
  })));
};
exports.EuiLinkTo = EuiLinkTo;
const EuiButtonTo = ({
  to,
  onClick,
  shouldNotCreateHref,
  ...rest
}) => {
  var _services$application2;
  const {
    services
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, rest, (0, _.generateReactRouterProps)({
    to,
    onClick,
    shouldNotCreateHref,
    http: services.http,
    navigateToUrl: (_services$application2 = services.application) === null || _services$application2 === void 0 ? void 0 : _services$application2.navigateToUrl,
    history: history
  })));
};
exports.EuiButtonTo = EuiButtonTo;
const EuiButtonEmptyTo = ({
  to,
  onClick,
  shouldNotCreateHref,
  ...rest
}) => {
  var _services$application3;
  const {
    services
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({}, rest, (0, _.generateReactRouterProps)({
    to,
    onClick,
    shouldNotCreateHref,
    http: services.http,
    navigateToUrl: (_services$application3 = services.application) === null || _services$application3 === void 0 ? void 0 : _services$application3.navigateToUrl,
    history: history
  })));
};
exports.EuiButtonEmptyTo = EuiButtonEmptyTo;
const EuiButtonIconTo = ({
  to,
  onClick,
  shouldNotCreateHref,
  ...rest
}) => {
  var _services$application4;
  const {
    services
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({}, rest, (0, _.generateReactRouterProps)({
    to,
    onClick,
    shouldNotCreateHref,
    http: services.http,
    navigateToUrl: (_services$application4 = services.application) === null || _services$application4 === void 0 ? void 0 : _services$application4.navigateToUrl,
    history: history
  })));
};
exports.EuiButtonIconTo = EuiButtonIconTo;
const EuiPanelTo = ({
  to,
  onClick,
  shouldNotCreateHref,
  ...rest
}) => {
  var _services$application5;
  const {
    services
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({}, rest, (0, _.generateReactRouterProps)({
    to,
    onClick,
    shouldNotCreateHref,
    http: services.http,
    navigateToUrl: (_services$application5 = services.application) === null || _services$application5 === void 0 ? void 0 : _services$application5.navigateToUrl,
    history: history
  })));
};
exports.EuiPanelTo = EuiPanelTo;
const EuiCardTo = ({
  to,
  onClick,
  shouldNotCreateHref,
  ...rest
}) => {
  var _services$application6;
  const {
    services
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, (0, _extends2.default)({}, rest, (0, _.generateReactRouterProps)({
    to,
    onClick,
    shouldNotCreateHref,
    http: services.http,
    navigateToUrl: (_services$application6 = services.application) === null || _services$application6 === void 0 ? void 0 : _services$application6.navigateToUrl,
    history: history
  })));
};
exports.EuiCardTo = EuiCardTo;
const EuiListGroupItemTo = ({
  to,
  onClick,
  shouldNotCreateHref,
  ...rest
}) => {
  var _services$application7;
  const {
    services
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, (0, _extends2.default)({}, rest, (0, _.generateReactRouterProps)({
    to,
    onClick,
    shouldNotCreateHref,
    http: services.http,
    navigateToUrl: (_services$application7 = services.application) === null || _services$application7 === void 0 ? void 0 : _services$application7.navigateToUrl,
    history: history
  })));
};

// TODO Right now this only supports the `color` prop of EuiBadgeProps
// Trying to use EuiBadgeProps in its entirety causes a succession of Typescript errors
exports.EuiListGroupItemTo = EuiListGroupItemTo;
const EuiBadgeTo = ({
  label,
  onClick,
  shouldNotCreateHref,
  to,
  ...rest
}) => {
  var _services$application8;
  const {
    services
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  const routerProps = (0, _.generateReactRouterProps)({
    onClick,
    shouldNotCreateHref,
    to,
    http: services.http,
    navigateToUrl: (_services$application8 = services.application) === null || _services$application8 === void 0 ? void 0 : _services$application8.navigateToUrl,
    history: history
  });
  const badgeProps = {
    ...rest,
    iconOnClick: routerProps.onClick,
    iconOnClickAriaLabel: label,
    onClick: routerProps.onClick,
    onClickAriaLabel: label
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({}, badgeProps, {
    className: "enterpriseSearchEuiBadgeTo"
  }), label);
};
exports.EuiBadgeTo = EuiBadgeTo;