"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareMenu = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../i18n/constants");
var _flatten_panel_tree = require("../../../lib/flatten_panel_tree");
var _popover = require("../../popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getShareDownloadJSONTitle: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderShareMenu.shareDownloadJSONTitle', {
    defaultMessage: 'Download as {JSON}',
    values: {
      JSON: _constants.JSON
    }
  }),
  getShareDownloadPDFTitle: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderShareMenu.shareDownloadPDFTitle', {
    defaultMessage: '{PDF} reports',
    values: {
      PDF: _constants.PDF
    }
  }),
  getShareMenuButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderShareMenu.shareMenuButtonLabel', {
    defaultMessage: 'Share'
  }),
  getShareWorkpadMessage: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderShareMenu.shareWorkpadMessage', {
    defaultMessage: 'Share this workpad'
  })
};
/**
 * The Menu for Exporting a Workpad from Canvas.
 */
const ShareMenu = ({
  ReportingComponent,
  onExport
}) => {
  const getPanelTree = closePopover => ({
    id: 0,
    items: [{
      name: strings.getShareDownloadJSONTitle(),
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "exportAction",
        size: "m"
      }),
      onClick: () => {
        onExport('json');
        closePopover();
      }
    }, ReportingComponent !== null ? {
      name: strings.getShareDownloadPDFTitle(),
      icon: 'document',
      panel: {
        id: 1,
        title: strings.getShareDownloadPDFTitle(),
        content: /*#__PURE__*/_react.default.createElement(ReportingComponent, {
          onClose: closePopover
        })
      },
      'data-test-subj': 'sharePanel-PDFReports'
    } : false].filter(Boolean)
  });
  const shareControl = togglePopover => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    "aria-label": strings.getShareWorkpadMessage(),
    onClick: togglePopover,
    "data-test-subj": "shareTopNavButton"
  }, strings.getShareMenuButtonLabel());
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    button: shareControl,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, ({
    closePopover
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: (0, _flatten_panel_tree.flattenPanelTree)(getPanelTree(closePopover))
  })));
};
exports.ShareMenu = ShareMenu;
ShareMenu.propTypes = {
  onExport: _propTypes.default.func.isRequired
};